// SPDX-License-Identifier: MIT


#include <libfebug.hpp>

#include <vector>

#include <algorithm>
#include <cstring>
#include <errno.h>

#include <unistd.h>


int main() {
	if(febug::global_controlled_socket != -1) {
		febug::formatters.emplace(typeid(std::vector<int>).hash_code(), [](int retpipe, std::size_t vid) {
			const std::vector<int> & data = *(const std::vector<int> *)vid;
			for(auto num : data)
				dprintf(retpipe, "%d ", num);
			write(retpipe, "\n", 1);
		});
		febug::formatters.emplace(typeid(std::size_t).hash_code(), [](int retpipe, std::size_t vid) {
			const std::size_t & data = *(const std::size_t *)vid;
			dprintf(retpipe, "%zu\n", data);
		});
	}


	struct sigaction handler {};
	handler.sa_handler = febug::debug_handler;
	if(sigaction(FEBUG_SIGNUM, &handler, nullptr) == -1)
		std::fprintf(stderr, "sigaction: %s\n", std::strerror(errno));


	{
		std::vector<int> data{-1, -2, -3, 0, 1, 2, 3, -1, -2, -3, 0, 1, 2, 3, -1, -2, -3, 0, 1, 2, 3,
		                      -1, -2, -3, 0, 1, 2, 3, -1, -2, -3, 0, 1, 2, 3, -1, -2, -3, 0, 1, 2, 3};
		std::size_t comparisons_done{};
		febug::wrapper data_w{data, "cool_data"};
		febug::wrapper comparisons_done_w{comparisons_done, "comparisons"};

		std::sort(data.begin(), data.end(), [&](auto lhs, auto rhs) {
			sleep(1);
			++comparisons_done;
			return lhs < rhs;
		});
	}

	sleep(2);
}
