use std::path::PathBuf;
use std::borrow::Cow;
use std::env;
use std::fs;


fn main() {
    println!("cargo:rerun-if-env-changed=FEBUG_DONT");
    println!("cargo:rerun-if-env-changed=FEBUG_SOCKET");
    println!("cargo:rerun-if-env-changed=FEBUG_SIGNUM");

    if env::var_os("FEBUG_DONT").is_some() {
        println!("cargo:rustc-cfg=febug_dont")
    }

    let febug_socket = env::var("FEBUG_SOCKET").map(Cow::from).unwrap_or(if env::var("CARGO_CFG_TARGET_OS").as_ref().map(String::as_str) == Ok("linux") {
        "/run/febug.sock".into()
    } else {
        "/var/run/febug.sock".into()
    });

    let febug_signum = env::var("FEBUG_SOCKET").map(Cow::from).unwrap_or("SIGUSR2".into());

    let outdir = PathBuf::from(env::var("OUT_DIR").unwrap());
    fs::create_dir_all(&outdir).unwrap();
    fs::write(outdir.join("febug_socket.rs"), format!("b{:?}", febug_socket)).unwrap();
    fs::write(outdir.join("febug_signum.rs"),
              if febug_signum.starts_with("S") {
                      format!("libc::{}", febug_signum).into()
                  } else {
                      febug_socket
                  }
                  .as_bytes())
        .unwrap();
}
