#if RUST_COMPILETIME
There are three compile-time environment variables that allow a programmer to customise its behaviour:
.Bl -tag -width Ds
.It
.Fd FEBUG_DONT
If set, all functions turn into no-ops;
#else
There are three compile-time macros that allow a program to customise its behaviour:
.Bl -tag -width Ds
.It
.Fd FEBUG_DONT
If non-zero, all symbols become
.Sy static ,
functions turn into no-ops, and therefore no symbols from LIBFEBUG.a/.so are imported at link-time;
#endif
this is intended as a way to easily disable
.Xr febug 8
integration completely on release builds.
.It
.Fd FEBUG_SIGNUM
The signal to request from
.Xr febug 8
when using
.Fn "febug_wrap" .
Defaults to
.Li SIGUSR2 .
.It
.Fd FEBUG_SOCKET
The path to connect to
.Xr febug 8
on. Defaults to
#if __linux__
.Pa /run/febug.sock .
#else
.Pa /var/run/febug.sock .
#endif
.El
.Pp
There are two environment variables that allow a user to customise its behaviour:
.Bl -tag -width Ds
.It Ev Em FEBUG_DONT
If set, don't try to connect to
.Xr febug 8 ,
so all library functions become no-ops.
.It Ev Em FEBUG_SOCKET
If set, use its value instead of
.Sy FEBUG_SOCKET
to connect to
.Xr febug 8
.El
