// SPDX-License-Identifier: MIT


#define _POSIX_C_SOURCE 200809L

#include <libfebug.h>

#include <signal.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>


#define CSTRING_FEBUG_TP 420
static void cstring_febug_formatter(int fd, size_t data) {
	const char * str = (const char *)data;
	dprintf(fd, "%s\n", str);
}


static int char_comp(const void * lhs, const void * rhs) {
	const struct timespec half_second = {0, 500 * 1000 * 1000};
	nanosleep(&half_second, 0);

	return *(const char *)lhs - *(const char *)rhs;
}


int main() {
	febug_start();
	febug_register_type(CSTRING_FEBUG_TP, cstring_febug_formatter);


	struct sigaction handler;
	memset(&handler, 0, sizeof(handler));
	handler.sa_handler = febug_debug_handler;
	if(sigaction(FEBUG_SIGNUM, &handler, 0) == -1) {
		fprintf(stderr, "sigaction: %s\n", strerror(errno));
		return 1;
	}


	{
		__attribute__((__cleanup__(febug_unwrap))) char data[] = "JVLOkgsYmhCyEFxouKzDNajivGlpWqbdBwnfTAXQcreRHPIUSMtZQWERTYUIOPqwertyuiop1234567890";
		febug_wrap(CSTRING_FEBUG_TP, data, "cool_data");

		qsort(data, strlen(data), 1, char_comp);
	}

	sleep(2);

	febug_end();
}
