// SPDX-License-Identifier: MIT


#pragma once


#include <stdint.h>


// Documented in febug-abi(5)


#ifndef __cplusplus
#define static_assert _Static_assert
#endif


#ifdef __cplusplus
extern "C" {
#endif

struct __attribute__((packed)) febug_message {
	uint64_t variable_id;
	uint64_t variable_type;
	uint8_t signal;
	char name[4096 - sizeof(uint64_t) - sizeof(uint64_t) - sizeof(uint8_t)];
};
static_assert(sizeof(struct febug_message) == 4096, "febug_message must be 4096 bytes");


struct __attribute__((packed)) stop_febug_message {
	uint64_t variable_id;
};
static_assert(sizeof(struct stop_febug_message) == 8, "stop_febug_message must be 8 bytes");

struct __attribute__((packed)) attn_febug_message {
	uint64_t variable_id;
	uint64_t variable_type;
};
static_assert(sizeof(struct attn_febug_message) == 8 + 8, "attn_febug_message must be 16 bytes");

static_assert(sizeof(struct febug_message) != sizeof(struct stop_febug_message), "febug_message same size as stop_febug_message");
static_assert(sizeof(struct febug_message) != sizeof(struct attn_febug_message), "febug_message same size as attn_febug_message");
static_assert(sizeof(struct stop_febug_message) != sizeof(struct attn_febug_message), "stop_febug_message same size as attn_febug_message");


#ifdef __cplusplus
}
#endif


#undef static_assert
