#!/usr/bin/env python3
# SPDX-License-Identifier: 0BSD


import febug, signal, time

signal.signal(febug.SIGNUM, febug.debug_handler)

## Python's list.sort() makes the list appear empty during the sort, so
##		def key(i, keys):
##			keys.of += 1
##			time.sleep(0.1)
##			return i
##		data.sort(key=lambda i: key(i, keys))
## wouldn't really show much
data = list(range(20))
with febug.Wrapper(0, "tests") as tests:
	with febug.Wrapper(data, "cool_data"):
		for i in range(len(data)):
			fact = []
			while data[i] > 1:
				for t in range(2, data[i] + 1):
					tests.of += 1
					time.sleep(0.1)
					if data[i] % t == 0:
						data[i] //= t
						fact.append(t)
			data[i] = fact
		time.sleep(2)
