// SPDX-License-Identifier: MIT


#pragma once


#include <signal.h>

#include <stdarg.h>
#include <stdint.h>
#include <stdio.h>


// Documented in libfebug(3)


#if FEBUG_DONT
#define FEBUG_MAYBE(...) static
#else
#define FEBUG_MAYBE(...) __VA_ARGS__
#endif

#ifndef FEBUG_SIGNUM
#define FEBUG_SIGNUM SIGUSR2
#endif

#ifndef FEBUG_SOCKET
#if __linux__
#define FEBUG_SOCKET "/run/febug.sock"
#else
#define FEBUG_SOCKET "/var/run/febug.sock"
#endif
#endif


#ifdef __cplusplus
extern "C" {
#endif


FEBUG_MAYBE(extern) int febug_global_controlled_socket;


FEBUG_MAYBE() void febug_start_path(const char * path);

static inline void febug_start(void) {
	febug_start_path(FEBUG_SOCKET);
}

FEBUG_MAYBE() void febug_end(void);


FEBUG_MAYBE() void febug_register_type(uint64_t type, void (*formatter)(int, size_t));
FEBUG_MAYBE() void febug_debug_handler(int);


__attribute__((format(printf, 4, 0))) FEBUG_MAYBE() void febug_wrap_signalv(uint64_t type, const void * data, uint8_t signal, const char * name, va_list ap);

__attribute__((format(printf, 4, 5))) static inline void febug_wrap_signal(uint64_t type, const void * data, uint8_t signal, const char * name, ...) {
	va_list ap;
	va_start(ap, name);
	febug_wrap_signalv(type, data, signal, name, ap);
	va_end(ap);
}

__attribute__((format(printf, 3, 4))) static inline void febug_wrap(uint64_t type, const void * data, const char * name, ...) {
	va_list ap;
	va_start(ap, name);
	febug_wrap_signalv(type, data, FEBUG_SIGNUM, name, ap);
	va_end(ap);
}

FEBUG_MAYBE() void febug_unwrap(const void * data);


#if FEBUG_DONT
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wunused-variable"
static int febug_global_controlled_socket = -1;
static void febug_start_path(const char * path) {}
static void febug_end(void) {}
static void febug_register_type(uint64_t type, void (*formatter)(int, size_t)) {}
static void febug_debug_handler(int _) {}
static void febug_wrap_signalv(uint64_t type, const void * data, uint8_t signal, const char * name, va_list ap) {}
static void febug_unwrap(const void * data) {}
#pragma GCC diagnostic pop
#endif


#ifdef __cplusplus
}
#endif
