#if RUST_COMPILETIME
#define DV Ev
There are three compile-time environment variables that allow customising
.Nm LIBFEBUG
behaviour:
.Bl -tag -compact -offset indent -width "FEBUG_SOCKET"
.It Ev FEBUG_DONT
If set, all functions turn into no-ops;
#else
#define DV Dv
There are three compile-time macros that allow customising
.Nm LIBFEBUG
behaviour:
.Bl -tag -compact -offset indent -width "FEBUG_SOCKET"
.It Dv FEBUG_DONT
If non-zero, all symbols become
.Sy static ,
functions turn into no-ops, and therefore no symbols from
.Pa LIBFEBUG.a Ns \&| Ns Pa .so
are imported at link-time;
#endif
this is intended as a way to easily disable
.Xr febug 8
integration completely on release builds.
.It DV FEBUG_SIGNUM
The signal to request from
.Xr febug 8
when using
.Fn "febug_wrap" .
Defaults to
.Dv SIGUSR2 .
.It DV FEBUG_SOCKET
The path to connect to
.Xr febug 8
on.
Defaults to
#if __linux__
.Pa /run/febug.sock .
#else
.Pa /var/run/febug.sock .
#endif
.El
.Pp
#include "libfebug-options-env.h"
