#!/bin/sh
# SPDX-License-Identifier: MIT
# shellcheck disable=SC2086


_get_backend() {
	OIFS="$IFS"
	IFS='
'
	rootfses="$(awk '$2 ~ "^(/|/etc|/bin|/lib|/lib??|/libx32|/usr)$" && $3 == "zfs" {print $1}' /etc/mtab)"
	[ -z "$rootfses" ] && IFS="$OIFS" && return 1

	eroots="$(zfs get encryptionroot -Ho value $rootfses | sort -u | grep -vFxe '' -e '-')"
	[ -z "$eroots" ] && IFS="$OIFS" && return 1

	backends="$(zfs-tpm-list -H $eroots | cut -f2 | sort -u)"
	[ -z "$backends" ] && IFS="$OIFS" && return 1

	IFS="$OIFS"
	return 0
}

_install_fido2() {
	inst_binary zfs-fido2-load-key
}


check() {
	command -v zfs-tpm-list > /dev/null || return 1

	# shellcheck disable=SC2154
	if [ -n "$hostonly" ]; then
		_get_backend || return

		for backend in $backends; do
			[ "$backend" = "FIDO2" ] && command -v zfs-fido2-load-key > /dev/null && return 0
		done

		return 1
	fi

	return 0
}


depends() {
	echo zfs fido2
}


installkernel() {
	instmods hid-generic usbhid
}


install() {
	inst_binary zfs-tpm-list

	if [ -n "$hostonly" ]; then
		_get_backend

		for backend in $backends; do
			[ "$backend" = "FIDO2" ] && _install_fido2
		done
	else
		command -v zfs-fido2-load-key > /dev/null && _install_fido2
	fi

	inst_hook pre-mount 89 "${moddir:-}/fzifdso-load-key.sh"  # zfs installs with 90, we *must* run beforehand
	inst_binary tee mkfifo sed
}
