#!/bin/sh
# SPDX-License-Identifier: MIT


#include "../mount.h"


# Included into /scripts/zfs in the initrd, replacing the original decrypt_fs(), now available as __fzifdso__decrypt_fs()
decrypt_fs() {
	fs="$1"

	# Bail early if we don't have even the common binaries
	if ! command -v zfs-tpm-list > /dev/null; then
		__fzifdso__decrypt_fs "$fs"
		return
	fi

	# First three lines borrowed from /scripts/zfs#decrypt_fs()
	# If pool encryption is active and the zfs command understands '-o encryption'
	if [ "$(zpool list -H -o feature@encryption "${fs%%/*}")" = "active" ]; then
		ENCRYPTIONROOT="$(get_fs_value "$fs" encryptionroot)"

		if ! [ "$ENCRYPTIONROOT" = "-" ]; then
			fzifdso_load "$ENCRYPTIONROOT" || return
			__fzifdso__decrypt_fs "${fs}"
			return
		fi
	fi

	return 0
}


WITH_PROMPTABLE_TTY{ }
