.\" SPDX-License-Identifier: MIT
.
.Dd
.Dt ZFS-FIDO2-CLEAR-KEY 8
.Os
.
.Sh NAME
.Nm zfs-fido2-clear-key
.Nd rewrap ZFS dataset key in passsword and clear tzpfms FIDO2 metadata
.Sh SYNOPSIS
.Nm
.Ar dataset
.
.Sh DESCRIPTION
After verifying
.Ar dataset
was encrypted with the
.Nm tzpfms
.Sy FIDO2
backend:
.Bl -enum -compact -offset 2n -width 2n
.It
performs the equivalent of
.Nm zfs Cm change-key Fl o Li keylocation=prompt Fl o Li keyformat=passphrase Ar dataset ,
.It
loads the primary and every backup credential, and for each success, if the device containing it supports the
.Ql credMgmt  \" or credentialMgmtPreview
feature and has a PIN set, tries to delete the credential from the device,
.It
removes the
.Li xyz.nabijaczleweli:tzpfms.\& Ns Brq Li backend , key
properties from
.Ar dataset .
.El
.Pp
For every removal failure and missing device or PIN an instruction for manual removal with
.Xr fido2-token 1
is issued.
.Pp
See
.Xr zfs-fido2-change-key 8
for a detailed description.
.
#include "passphrase.h"
.
#include "backend-fido2.h"
.
#include "common.h"
