/* SPDX-License-Identifier: 0BSD */


#pragma once


#include "load-key.hpp"


struct clear_key_bundle : load_key_bundle {
	struct {
		bool primary;
		bool * backups;
	} found;

	~clear_key_bundle();
};


int zfs_fido2_clear_key_handle(clear_key_bundle & dt, zfs_handle_t * dataset, char * handle_s);
void zfs_fido2_clear_key_free(clear_key_bundle & dt);
void zfs_fido2_clear_key_free_one(fido2_device & device, const char * dataset_name, const fido2_cred_bundle & bundle);
void zfs_fido2_clear_key_unhandle(clear_key_bundle & dt);
