/* SPDX-License-Identifier: 0BSD */


#pragma once


#include "../fido2.hpp"
#include "../zfs.hpp"


struct load_key_bundle {
	const char * dataset_name;

	fido2_cred_bundle bundle;
	fido2_backup_cred_bundle * backups;
	size_t backups_len;

	uint8_t wrap_key[WRAPPING_KEY_LEN];
};


#define UNLOCK_PRIMARY(...)                                                                \
	auto err = fido2_loadkey(dt.wrap_key, dt.dataset_name, false, dev, dt.bundle, &ret_ret); \
	if(err && ret_ret)                                                                       \
		return err;                                                                            \
	if(!err) {                                                                               \
		__VA_ARGS__                                                                            \
	}

#define UNLOCK_BACKUP()                                                                      \
	uint8_t sym_key[AES_KEY_LEN];                                                              \
	bool fatal{};                                                                              \
	auto err = fido2_loadkey(sym_key, dt.dataset_name, true, dev, dt.backups[i].cred, &fatal); \
	if(err && fatal)                                                                           \
		return ret_ret = true, err;                                                              \
	if(err)                                                                                    \
		continue;                                                                                \
                                                                                             \
	TRY_MAIN(decrypt_backup(dt.wrap_key, sym_key, dt.backups[i].iv, dt.backups[i].encrypted));
