/* SPDX-License-Identifier: 0BSD */


#include "../main_clear.hpp"
#include "clear-key.hpp"


#define THIS_BACKEND "FIDO2"


int main(int argc, char ** argv) {
	clear_key_bundle dt{};
	return do_clear_main(
	    argc, argv, THIS_BACKEND, [&](auto dataset, auto handle_s) { return zfs_fido2_clear_key_handle(dt, dataset, handle_s); },
	    [&] {
		    fido_init(0);
		    zfs_fido2_clear_key_free(dt);
		    return 0;
	    });
}
