/* SPDX-License-Identifier: 0BSD */


#pragma once


#include "fido2.hpp"
#include "zfs.hpp"
#include <openssl/err.h>


#define TRY_OSSL(what, ...) TRY_GENERIC(what, !, , ERR_get_error(), __LINE__, ([](auto e) { return ERR_error_string(e, nullptr); }), __VA_ARGS__)


#define AES_KEY_LEN (256 / 8)

extern int encrypt_backup(uint8_t (&encrypted)[ENCRYPTED_LEN], const uint8_t (&sym_key)[AES_KEY_LEN], const uint8_t (&iv)[ENCRYPTED_AES_IV_LEN],
                          const uint8_t (&wrap_key)[WRAPPING_KEY_LEN]);
extern int decrypt_backup(uint8_t (&wrap_key)[WRAPPING_KEY_LEN], const uint8_t (&sym_key)[AES_KEY_LEN], const uint8_t (&iv)[ENCRYPTED_AES_IV_LEN],
                          const uint8_t (&encrypted)[ENCRYPTED_LEN]);
