# fzifdso [![builds.sr.ht badge](//builds.sr.ht/~nabijaczleweli/fzifdso.svg)](//builds.sr.ht/~nabijaczleweli/fzifdso)
FIDO2/WebAuthn-based (YubiKey, Somu, &c.) encryption keys for ZFS datasets.

## [Manpages](//ra.ws.co.ls/~nabijaczleweli/tzpfms/blob/man/zfs-fido2-change-key.8.html) ([PDF](//ra.ws.co.ls/~nabijaczleweli/tzpfms/blob/man/tzpfms.pdf))

### Why?

```
F I D O
 Z F S
```

### What?

Much like [tzpfms](//git.sr.ht/~nabijaczleweli/tzpfms):
WebAuthn, but for ZFS –
a `hmac-secret`ted challenge is generated on the device (registration), and a salt is ran through it during an assertion (login),
tying the dataset key to the FIDO2 device.

Both dracut (with/without Plymouth) (with/without hostonly) (only on systemd systems, I don't have a test-bed for the non-systemd path)
and initramfs-tools (with/without Plymouth) are supported for [ZFS-on-root](//nabijaczleweli.xyz/content/blogn_t/005-low-curse-zfs-on-root.html) set-ups.

### Building

You'll need `pkgconf`, `shellcheck`, `libzfslinux-dev` (0.8.x and 2.[012].x work), `libfido2-dev`, and `make` should hopefully Just Work™ if you have a C++17-capable compiler.
The output binaries are trimmed of extraneous dependencies, so they're all just libc + libzfs and friends + libfido2 + maybe libcrypto.

`mandoc` is required for HTML manuals. Set `MANDOC=true` to forgo this.

The default `$TZPFMS_PASSPHRASE_HELPER` is the null string.
To set a different default, set `TZPFMS_PASSPHRASE_HELPER` and `TZPFMS_PASSPHRASE_HELPER_MAN` for `make` — `$`s need to be double-escaped and `'`s need to be full-`'` escaped (i.e. `'\''`).

As an example, for a sensible default value of `exec systemd-ask-password --id="tzpfms:$2" "$1:"` for OOB systemd integration, pass `TZPFMS_PASSPHRASE_HELPER='exec systemd-ask-password --id="tzpfms:$$2" "$$1:"'` and `TZPFMS_PASSPHRASE_HELPER_MAN='Ic exec Nm systemd-ask-password Fl -id Ns Li = Ns Qo Li tzpfms:\& Ns Ar $$2 Qc Qo Ar $$1 Ns Li ":\&" Qc'`.

### Installation

Copy the `out/zfs-fido2*` binaries corresponding to the back-ends you want to `/sbin`,
continue as the [manual](//ra.ws.co.ls/~nabijaczleweli/fzifdso/blob/man/zfs-fido2-change-key.8.html) instructs.

For initrd support, copy the content of either `out/dracut/` or `out/initramfs-tools/` over `/`;
these need `zfs-tpm-list` but will work with any combination of back-end `*-load-key` binaries.

To integrate with [zfs-mount-generator(8)](//manpages.debian.org/bookworm/zfsutils-linux/zfs-mount-generator.8.html)
[copy](//lfs.nabijaczleweli.xyz/0017-twitter-export#1472986504272261124) `out/systemd/` over `/`.

[zfs-tpm-list(8)](//ra.ws.co.ls/~nabijaczleweli/fzifdso/blob/man/zfs-tpm-list.8.html) and the `zfs-load-key@.service` override are *not* shipped here;
they live in [tzpfms](//git.sr.ht/~nabijaczleweli/tzpfms) (the "tzpfms-common" package) only.

#### From Debian repository

The following line in `/etc/apt/sources.list` or equivalent:
```apt
deb [signed-by=/etc/apt/keyrings/nabijaczleweli.asc] https://debian.nabijaczleweli.xyz sid main
```

With [my PGP key](//nabijaczleweli.xyz/pgp.txt) (the two URLs are interchangeable):
```sh
sudo wget -O/etc/apt/keyrings/nabijaczleweli.asc https://debian.nabijaczleweli.xyz/nabijaczleweli.gpg.key
sudo wget -O/etc/apt/keyrings/nabijaczleweli.asc https://nabijaczleweli.xyz/pgp.txt
```
(you may need to create /etc/apt/keyrings on apt <2.4.0 (<=bullseye) manually).

Then the usual
```sh
sudo apt update
sudo apt install fzifdso fzifdso-dracut
```
will work on amd64, x32, and i386.

See the [repository README](//debian.nabijaczleweli.xyz/README) for more information.

#### From tar-ball

Release tarballs are signed with <nabijaczleweli@nabijaczleweli.xyz> (pull with WKD, but `7D69 474E 8402 8C5C C0C4  4163 BCFD 0B01 8D26 58F1`).
аnd stored in git notes as-if via [the example program](//man.sr.ht/git.sr.ht/#signing-tags-tarballs)
and are thus available on the [refs listing](//git.sr.ht/~nabijaczleweli/fzifdso/refs)/tag page as .tar.gz.asc.

### Testing

Tested on the Somu and YubiKey 5 USB-A [Nano].

[virtual-fido](//github.com/bulwarkid/virtual-fido) doesn't work, because it [doesn't have the hmac-secret extension](//github.com/bulwarkid/virtual-fido/issues/33).

## Reporting bugs

There's [the tracker](//todo.sr.ht/~nabijaczleweli/fzifdso), but also see the list below.

## Contributing

Send a patch inline, as an attachment, or a git link and a ref to pull from to
[the list](//lists.sr.ht/~nabijaczleweli/tzpfms) ([~nabijaczleweli/tzpfms@lists.sr.ht](mailto:~nabijaczleweli/tzpfms@lists.sr.ht)) or [me](mailto:nabijaczleweli@nabijaczleweli.xyz)
directly. I'm not picky, just please include the repo name in the subject prefix.

This repository is regularly merged from tzpfms HEAD (with significant changes) to track the commonalities (which are the plurality of the code here).

## Discussion

Please use the tracker, the list, or [mastussy](//101010.pl/@nabijaczleweli) (formerly [Twitter](//lfs.nabijaczleweli.xyz/0017-twitter-export#1376271660618293257)).

## Special thanks

To all who support further development on Patreon, in particular:

  * ThePhD
  * Embark Studios
  * Jasper Bekkers
  * EvModder
