# SPDX-License-Identifier: MIT


#define WITH_PROMPTABLE_TTY(REDIREXIONS)
	fzfidso_with_promptable_tty() {
		if plymouth --ping 2>/dev/null; then
			mkfifo /run/fzifdso-pipe
			< /run/fzifdso-pipe tee /run/fzifdso-err | while read -r line; do plymouth display-message --text="$line"; printf '%s\n' "$line" >&2; done &
			# shellcheck disable=SC2016
			TZPFMS_PASSPHRASE_HELPER='exec plymouth ask-for-password --prompt="$1: "' "$@" > /run/fzifdso-pipe 2>&1; ret="$?"
			wait $!
		elif [ -e /run/systemd/system ] && command -v systemd-ask-password > /dev/null; then  # --no-tty matches zfs and actually works
			mkfifo /run/fzifdso-pipe
			< /run/fzifdso-pipe tee /run/fzifdso-err >&2 &
			# shellcheck disable=SC2016
			TZPFMS_PASSPHRASE_HELPER='exec systemd-ask-password --no-tty --id="tzpfms:$2" "$1:"' "$@" > /run/fzifdso-pipe 2>&1; ret="$?"
			wait $!
		else
			# Mimic /scripts/zfs#decrypt_fs(): setting "printk" temporarily to "7" will allow prompt even if kernel option "quiet"
			read -r printk _ < /proc/sys/kernel/printk
			[ "$printk" = "7" ] || echo 7 > /proc/sys/kernel/printk

			TZPFMS_PASSPHRASE_HELPER="${TZPFMS_PASSPHRASE_HELPER:-}" "$@" REDIREXIONS; ret="$?"  # allow overriding in cmdline, but always set to raze default

			[ "$printk" = "7" ] || echo "$printk" > /proc/sys/kernel/printk
		fi
		[ -s /run/fzifdso-err ] && [ "$ret" -ne 0 ] && sed 's;^;'"$1"': ;' /run/fzifdso-err >> /dev/kmsg
		rm -f /run/fzifdso-err /run/fzifdso-pipe
		return "$ret"
	}
#endefine


fzifdso_load() {
	set -- "$(zfs get -Ho value encryptionroot "$1")"
	[ "$1" = "-" ] && return 0

	if command -v zfs-fido2-load-key > /dev/null && [ -n "$(zfs-tpm-list -Hub FIDO2 "$1")" ]; then
		fzfidso_with_promptable_tty zfs-fido2-load-key "$1"
	fi
}
