.\" SPDX-License-Identifier: MIT
.
.Dd
.Dt ZFS-FIDO2-ADD-BACKUP 8
.Os
.
.Sh NAME
.Nm zfs-fido2-add-backup
.Nd allow another FIDO2 device to unlock ZFS dataset
.Sh SYNOPSIS
.Nm
.Ar dataset
.
.Sh DESCRIPTION
After
.Xr zfs-fido2-change-key 8
derives the key for a dataset from a FIDO2 device,
.Nm
may be executed to extend this to any number of additional devices.
.Pp
First, the wrapping key is extracted as normally during
.Xr zfs-fido2-load-key 8 ,
then a credential is made as-if during
.Xr zfs-fido2-change-key 8
(except the "primary" device and all the ones holding backups are excluded from the search);
however, the
.Ql hmac-secret
is instead used as a symmetric AES-256-GCM
.Pq Xr EVP_CIPHER-AES 7ssl
key to encrypt the wrapping key directly with a random IV.
.Pp
This turns the
.Li xyz.nabijaczleweli:tzpfms.key
variable into a dot-separated list of device bundles:
.Bd -ragged -compact -offset 2n
.Ar salt Ns Cm :\:\& Ns Ar credential-ID Ns Cm :\:\& Ns Ar credential-public-key Ns Oo Cm \&. Ns Ar backup-salt Ns Cm :\:\& Ns Ar backup-credential-ID Ns Cm :\:\& Ns Ar backup-credential-public-key Ns Cm :\:\& Ns Ar IV Ns Cm :\:\& Ns Ar encrypted-key Oc Ns …
.Ed
The first one is as-described in
.Xr zfs-fido2-change-key 8 .
Subsequent ones also include (identically-encoded) IVs and encrypted blobs.
.Pp
.Xr zfs-fido2-load-key 8
shops assertions around devices in a device-major order \(em
depending on device numbering, a backup may be loaded even if the primary device is present.
.
#include "passphrase.h"
.
#include "backend-fido2.h"
.
#include "common.h"
