.\" SPDX-License-Identifier: MIT
.
.Dd
.Dt ZFS-FIDO2-CHANGE-KEY 8
.Os
.
.Sh NAME
.Nm zfs-fido2-change-key
.Nd change ZFS dataset key to one authenticated by a FIDO2 device
.Sh SYNOPSIS
.Nm
.Op Fl b Ar backup-file
.Ar dataset
.
.Sh DESCRIPTION
To normalise the
.Ar dataset ,
.Nm
will open its encryption root in its stead.
.Nm
will
.Em never
create or destroy encryption roots; use
.Xr zfs-change-key 8
for that.
.Pp
First, a connection is made to the FIDO2 device, which
.Em must
support the
.Ql hmac-secret
extension.
.Pp
If
.Ar dataset
was previously encrypted with
.Nm fzifdso
and the
.Sy FIDO2
back-end was used, previous credentials will be deleted from their devices (as-if via
.Xr zfs-fido2-clear-key 8 ) ,
if available.
Otherwise, or in case of an error, data required for manual intervention will be written to the standard error stream.
.Pp
Next, a new credential of type ES256 is generated on the device (with relying party ID
.Li fzifdso
and name equal to the dataset name)
with the
.Ql hmac-secret
extension requested; the device PIN, if any, is prompted for here.
This mimicks a WebAuthn registration step.
.Pp
Then, the credential is asserted with a 32-byte random salt,
which hashes it with device-private data, and thus generates the wrapping key
.Pq which is optionally backed up Pq see Sx OPTIONS .
This mimicks a WebAuthn login step.
.Pp
The following properties are set on
.Ar dataset :
.Bl -bullet -compact -offset 4n -width "@"
.It
.Li xyz.nabijaczleweli:tzpfms.backend Ns = Ns Sy FIDO2
.It
.Li xyz.nabijaczleweli:tzpfms.key Ns = Ns Ar salt Ns Cm :\:\& Ns Ar credential-ID Ns Cm :\:\& Ns Ar credential-public-key Ns Oo Cm \&. Ns … Oc Ns …
.El
.Pp
.Li tzpfms.backend
identifies this dataset for work with
.Sy FIDO2 Ns -back-ended
.Nm tzpfms
tools
.Pq i.e. Nm fzifdso Xr zfs-fido2-change-key 8 , Xr zfs-fido2-load-key 8 , Xr zfs-fido2-add-backup 8 , and Xr zfs-fido2-clear-key 8 .
.Pp
.Li tzpfms.key
is a colon-separated tuple of unpadded URL-safe base64 blobs;
the first one is the random salt;
the second represents the ID of created credential,
and the third \(en its public key.
There exists no other user-land tool for deciphering this; perhaps there should be.
.\"" TODO: make an LD_PRELOADable for extracting the key maybe?
.Pp
Finally, the equivalent of
.Nm zfs Cm change-key Fl o Li keylocation=prompt Fl o Li keyformat=raw Ar dataset
is performed with the new key.
If an error occurred, best effort is made to clean up the properties,
or to issue a note for manual intervention into the standard error stream.
.Pp
A final verification should be made by running
.Nm zfs-fido2-load-key Fl n Ar dataset .
If that command succeeds, all is well,
but otherwise the dataset can be manually rolled back to a passphrase with
.Nm zfs-fido2-clear-key Ar dataset
.Pq or, if that fails to work, Nm zfs Cm change-key Fl o Li keyformat=passphrase Ar dataset ,
and you are hereby asked to report a bug, please.
.Pp
.Nm zfs-fido2-clear-key Ar dataset
can be used to clear the properties and go back to using a passphrase.
.
.Sh OPTIONS
.Bl -tag -compact -width ".Fl b Ar backup-file"
.It Fl b Ar backup-file
Save a back-up of the key to
.Ar backup-file ,
which must not exist beforehand.
This back-up
.Em must
be stored securely, off-site.
In case of a catastrophic event, the key can be loaded by running
.Dl Nm zfs Cm load-key Ar dataset Li < Ar backup-file
.El
.
#include "passphrase.h"
.
#include "backend-fido2.h"
.
#include "common.h"
