.\" SPDX-License-Identifier: MIT
.
.Dd
.Dt ZFS-FIDO2-LOAD-KEY 8
.Os
.
.Sh NAME
.Nm zfs-fido2-load-key
.Nd load FIDO2-encrypted ZFS dataset key
.Sh SYNOPSIS
.Nm
.Op Fl n
.Ar dataset
.
.Sh DESCRIPTION
After verifying
.Ar dataset
was encrypted with the
.Nm tzpfms
.Sy FIDO2
backend,
asserts the preserved challenge, HMACking the salt with the on-device secret, and loads the resulting key into
.Ar dataset .
.Pp
See
.Xr zfs-fido2-change-key 8
for a detailed description.
.
.Sh OPTIONS
.Bl -tag -compact -width ".Fl n"
.It Fl n
Do a no-op/dry run, can be used even if the key is already loaded.
Equivalent to
.Nm zfs Cm load-key Ns 's
.Fl n
option.
.El
.
#include "passphrase.h"
.
#include "backend-fido2.h"
.
#include "common.h"
