/* SPDX-License-Identifier: 0BSD */


#include "../fido2.hpp"
#include "../main.hpp"
#include "../openssl.hpp"
#include "../zfs.hpp"
#include "load-key.hpp"


#define THIS_BACKEND "FIDO2"


int main(int argc, char ** argv) {
	auto noop = false;
	return do_main(
	    argc, argv, "n", "[-n]", [&](auto) { noop = true; },
	    [&](auto dataset) {
		    char * handle_s{};
		    TRY_MAIN(parse_key_props(dataset, THIS_BACKEND, handle_s));

		    load_key_bundle dt;
		    dt.dataset_name = zfs_get_name(dataset);
		    TRY_MAIN(fido2_parse_prop(dt.bundle, dt.backups, dt.backups_len, zfs_get_name(dataset), handle_s));


		    fido_init(0);
		    fido2_device dev;
		    TRY_MAIN(fido2_find_device(
		        dev,
		        [](fido2_device & dev, bool & ret_ret, void * dt_raw) {
			        auto & dt = *reinterpret_cast<load_key_bundle *>(dt_raw);

			        UNLOCK_PRIMARY(return 0;)

			        for(size_t i = 0; i < dt.backups_len; ++i) {
				        UNLOCK_BACKUP()
				        return 0;
			        }

			        return err;
		        },
		        &dt));

		    return load_key(dataset, dt.wrap_key, noop);
	    });
}
