# klapki [![builds.sr.ht badge](//builds.sr.ht/~nabijaczleweli/klapki.svg)](https://builds.sr.ht/~nabijaczleweli/klapki) [![Licence](//img.shields.io/badge/license-MIT-blue.svg?style=flat)](LICENSE)
EFI boot manager; or, well, an EFI bootorder [compiler](//twitter.com/nabijaczleweli/status/1306144037070569472).

## [Manpage](//sr.ht/~nabijaczleweli/klapki)

### Building

You'll need `libssl-dev` and `libefi{var,boot}-dev`, and `make` should hopefully Just Work™ if you have a C++17-capable compiler.

Note that `klapki` uses Linux-specific [`memfd`](//manpages.debian.org/buster/manpages-dev/memfd_create.2.en.html)
and [`sendfile()`](//manpages.debian.org/buster/manpages-dev/sendfile.2.en.html) interfaces, and as such building it will fail on other systems.
AFAICT libefivar only supports Linux anyway, but these will have to be ported in case it doesn't (patches welcome, &c.).

### Installation

Copy `out/klapki` to `/sbin` and write a `/etc/klapki/{description,cmdline}`, as seen in the [manpage](//git.sr.ht/~nabijaczleweli/klapki/tree/trunk/man/klapki.md),

#### From Debian repository

The following line in `/etc/apt/sources.list` or equivalent:
```apt
deb //debian.nabijaczleweli.xyz stable main
```

With [my PGP key](//nabijaczleweli.xyz/pgp.txt) (the two URLs are interchangeable):
```sh
wget -O- //debian.nabijaczleweli.xyz/nabijaczleweli.gpg.key | sudo apt-key add
# or
sudo wget -O/etc/apt/trusted.gpg.d/nabijaczleweli.asc //keybase.io/nabijaczleweli/pgp_keys.asc
```

Then the usual
```sh
sudo apt update
sudo apt install klapki
```
will work on amd64, x32, and i386.

See the [repository README](//debian.nabijaczleweli.xyz/README) for more information.

## Uninstallation

Remove the variable corresponding to the host under the klapki GUID (`a8a9ad3a-f831-11ea-946d-674ccd7415cc`).

For example, on Linux, with host "zoot":
```sh
chattr -i /sys/firmware/efi/efivars/zoot-a8a9ad3a-f831-11ea-946d-674ccd7415cc
rm        /sys/firmware/efi/efivars/zoot-a8a9ad3a-f831-11ea-946d-674ccd7415cc
```

This will abandon any previously-managed entries by removing all state, so either run `{delkernel ver}` for all versions you had registered beforehand,
or remove the entries and files later with [`efibootmgr(8)`](//manpages.debian.org/buster/efibootmgr/efibootmgr.8.en.html)/EFI shell/the firmware UI.

## Reporting bugs

There's [the tracker](//todo.sr.ht/~nabijaczleweli/klapki), but also see the list below.

## Contributing

Send a patch inline, as an attachment, or a git link and a ref to pull from to
[the list](//lists.sr.ht/~nabijaczleweli/klapki) ([~nabijaczleweli/klapki@lists.sr.ht](mailto:~nabijaczleweli/klapki)) or [me](mailto:nabijaczleweli@nabijaczleweli.xyz)
directly. I'm not picky, just please include the repo name in the subject prefix.

## Discussion

Please use the tracker, the list, or [Twitter](//twitter.com/nabijaczleweli/status/1306144037070569472).

## Special thanks

To all who support further development on Patreon, in particular:

  * ThePhD
  * Embark Studios
