# klapki [![builds.sr.ht badge](//builds.sr.ht/~nabijaczleweli/klapki.svg)](//builds.sr.ht/~nabijaczleweli/klapki) [![Licence](//img.shields.io/badge/license-MIT-blue.svg?style=flat)](LICENSE)
EFI boot manager; or, well, an EFI bootorder [compiler](//twitter.com/nabijaczleweli/status/1306144037070569472).

## [Manpage](//srhtcdn.githack.com/~nabijaczleweli/klapki/blob/man/klapki.8.html)

[![screenshot of OVMF Boot Manager Nenu, showing an entry called "zoot", four similar entries starting with "Debian GNU/Linux" grouped by two kernel versions, the bottom entry of each version being suffixed with "(graphical)", then "Linux Boot Manager"](screenshot.png)](screenshot.png)

### What?

You need to boot Linux somehow,
but you [don't really need](//git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/plain/Documentation/admin-guide/efi-stub.rst?h=v5.8)
any EFI-side code to do it if you configure your kernel right and have something tell the firmware about it. This is that something.

klapki stores neither code nor data (well, except the kernel and initrds) on the ESP
(which I think makes it secure-boot-compatible, but I haven't managed to ever use secure boot yet, so)
and instead generates entries for the host's kernels and manages them during their lifetime from the host itself.

Because of this, entries for each host can be trivially placed anywhere in the boot order (in the screenshot they're at `{bootpos 1}`, preceded by the "zoot" entry).

As seen in the screenshot, additional boot variants (just "graphical" in that case) are also supported, generating another entry for each kernel;
OVMF doesn't show it, but the difference can be seen from this listing of `/etc/klapki/cmdline` used to generate those entries;
(the [description](//git.sr.ht/~nabijaczleweli/klapki.deb/tree/50de836242adb578bc1bb6c288ddc450c4a4765c/debian/description) is a tad verbose to match convention):
```sh
#!/bin/sh
echo root=ZFS=zoot/root
[ "$2" = "graphical" ] || echo console=ttyS0
```

### Building

You'll need `libssl-dev` and `libefi{var,boot}-dev`, to initialise the submodules, and `make` should hopefully Just Work™ if you have a C++17-capable compiler.

Note that `klapki` uses Linux-specific [`memfd`](//manpages.debian.org/buster/manpages-dev/memfd_create.2.en.html)
and [`sendfile()`](//manpages.debian.org/buster/manpages-dev/sendfile.2.en.html) interfaces, and as such building it will fail on other systems.
AFAICT libefivar only supports Linux anyway, but these will have to be ported in case it doesn't (patches welcome, &c.).

### Installation

Copy `out/klapki` to `/sbin` and write a `/etc/klapki/{description,cmdline}`, as seen in the [manpage](//git.sr.ht/~nabijaczleweli/klapki/tree/trunk/man/klapki.md),

#### From Debian repository

The following line in `/etc/apt/sources.list` or equivalent:
```apt
deb https://debian.nabijaczleweli.xyz sid main
```

With [my PGP key](//nabijaczleweli.xyz/pgp.txt) (the two URLs are interchangeable):
```sh
wget -O- https://debian.nabijaczleweli.xyz/nabijaczleweli.gpg.key | sudo apt-key add
# or
sudo wget -O/etc/apt/trusted.gpg.d/nabijaczleweli.asc //keybase.io/nabijaczleweli/pgp_keys.asc
```

Then the usual
```sh
sudo apt update
sudo apt install klapki
```
will work on amd64, x32, and i386.

See the [repository README](//debian.nabijaczleweli.xyz/README) for more information.

## Uninstallation

Remove the variable corresponding to the host under the klapki GUID (`a8a9ad3a-f831-11ea-946d-674ccd7415cc`).

For example, on Linux, with host "zoot":
```sh
chattr -i /sys/firmware/efi/efivars/zoot-a8a9ad3a-f831-11ea-946d-674ccd7415cc
rm        /sys/firmware/efi/efivars/zoot-a8a9ad3a-f831-11ea-946d-674ccd7415cc
```

This will abandon any previously-managed entries by removing all state, so either run `{delkernel ver}` for all versions you had registered beforehand,
or remove the entries and files later with [`efibootmgr(8)`](//manpages.debian.org/buster/efibootmgr/efibootmgr.8.en.html)/EFI shell/the firmware UI.

## Reporting bugs

There's [the tracker](//todo.sr.ht/~nabijaczleweli/klapki), but also see the list below.

## Contributing

Send a patch inline, as an attachment, or a git link and a ref to pull from to
[the list](//lists.sr.ht/~nabijaczleweli/klapki) ([~nabijaczleweli/klapki@lists.sr.ht](mailto:~nabijaczleweli/klapki)) or [me](mailto:nabijaczleweli@nabijaczleweli.xyz)
directly. I'm not picky, just please include the repo name in the subject prefix.

## Discussion

Please use the tracker, the list, or [Twitter](//twitter.com/nabijaczleweli/status/1306144037070569472).

## Special thanks

To all who support further development on Patreon, in particular:

  * ThePhD
  * Embark Studios
