// The MIT License (MIT)

// Copyright (c) 2020 наб <nabijaczleweli@nabijaczleweli.xyz>

// Permission is hereby granted, free of charge, to any person obtaining a copy of
// this software and associated documentation files (the "Software"), to deal in
// the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


#include "efi.hpp"
#include <byteswap.h>
#include <endian.h>


// As seen in <efivar/efivar.h>, ish
#if BYTE_ORDER == LITTLE_ENDIAN
#define MAYBESWAP(d) __builtin_bswap16(d)
#else
#define MAYBESWAP(d) (d)
#endif


/// uuid(1) spat this out
const char * const klapki::efi_guid_klapki_s = "a8a9ad3a-f831-11ea-946d-674ccd7415cc";
const efi_guid_t klapki::efi_guid_klapki{0xa8a9ad3a, 0xf831, 0x11ea, MAYBESWAP(0x946d), {0x67, 0x4c, 0xcd, 0x74, 0x15, 0xcc}};
