# klapki [![builds.sr.ht badge](//builds.sr.ht/~nabijaczleweli/klapki.svg)](//builds.sr.ht/~nabijaczleweli/klapki) [![Licence](//img.shields.io/badge/license-MIT-blue.svg?style=flat)](LICENSE)
EFI boot manager; or, well, an EFI bootorder [compiler](//twitter.com/nabijaczleweli/status/1306144037070569472).

## [Manpage](//srhtcdn.githack.com/~nabijaczleweli/klapki/blob/man/klapki.8.html) ([PDF](//srhtcdn.githack.com/~nabijaczleweli/klapki/blob/man/klapki.pdf))

[![screenshot of OVMF Boot Manager Nenu, showing an entry called "zoot", four similar entries starting with "Debian GNU/Linux" grouped by two kernel versions, the bottom entry of each version being suffixed with "(graphical)", then "Linux Boot Manager"](screenshot.png)](screenshot.png)
[![screenshot of Dell R710 UEFI Boot Manager menu, showing a set of entries under the Embedded SATA Port B Disk, designated "Debian GNU/Linux 11 (bullseye)" grouped by two kernel versions, the bottom entry of each version being suffixed with "(rd.break=pre-pivot emergency)", then an entry fot the Port A Optical drive, then Front USB](screenshot-R710.png)](//twitter.com/nabijaczleweli/status/1445781958865264640) <!-- actual screenshot from later down: //twitter.com/nabijaczleweli/status/1446305415227224074 -->

### What?

You need to boot Linux somehow,
but you [don't really need](//git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/plain/Documentation/admin-guide/efi-stub.rst?h=v5.8)
any EFI-side code to do it if you configure your kernel right and have something tell the firmware about it. This is that something.

klapki stores neither code nor data (well, except the kernel and initrds) on the ESP, making it SecureBoot-compatible out-of-box,
and instead generates entries for the host's kernels and manages them during their lifetime from the host itself.

Because of this, entries for each host can be trivially placed anywhere in the boot order (in the screenshot they're at `{bootpos 1}`, preceded by the "zoot" entry).

As seen in the screenshot, additional boot variants (just "graphical" in that case) are also supported, generating another entry for each kernel;
OVMF doesn't show it, but the difference can be seen from this listing of `/etc/klapki/cmdline` used to generate those entries
(the [description](//git.sr.ht/~nabijaczleweli/klapki.deb/tree/50de836242adb578bc1bb6c288ddc450c4a4765c/debian/description) is a tad verbose to match convention):
```sh
#!/bin/sh
echo root=ZFS=zoot/root
[ "$2" = "graphical" ] || echo console=ttyS0
```

The second screenshot goes for the [radical](//twitter.com/nabijaczleweli/status/1446305415227224074)
```sh
#!/bin/sh
echo root=zfs:AUTO intel_iommu=on zfs.zfs_arc_max=85899345920 "$2"
```

### Building

You'll need `libssl-dev`, `libefi{var,boot}-dev`, `catch2`, `libfmt-dev` and `make` should hopefully Just Work™ if you have a C++17-capable compiler.

`catch2` and `libfmt-dev` are searched via `pkg-config` as `catch2`/`fmt` if available, or in `$ADDITIONAL_INCLUDE_DIR`/`$ADDITIONAL_LINK_DIR`.

`mandoc` is required for HTML manpages. Set `MANDOC=true` when building to remove this dependency.

Note that `klapki` uses Linux-specific [`sendfile()`](//manpages.debian.org/bullseye/sendfile.2), and as such building it will fail on other systems.
Upstream libefivar only supports Linux anyway
(and FreeBSD [carries](//freshports.org/devel/efivar) a port, though the usefulness of this within any classic UNIX distribution is doubtful).

### Installation

Copy `out/klapki` to `/sbin` and write a `/etc/klapki/{description,cmdline}`, as seen in the [manual](//srhtcdn.githack.com/~nabijaczleweli/klapki/blob/man/klapki.8.html).

#### From Debian repository

The following line in `/etc/apt/sources.list` or equivalent:
```apt
deb https://debian.nabijaczleweli.xyz sid main
```

With [my PGP key](//nabijaczleweli.xyz/pgp.txt) (the two URLs are interchangeable):
```sh
sudo wget -O/etc/apt/trusted.gpg.d/nabijaczleweli.asc https://debian.nabijaczleweli.xyz/nabijaczleweli.gpg.key
sudo wget -O/etc/apt/trusted.gpg.d/nabijaczleweli.asc https://keybase.io/nabijaczleweli/pgp_keys.asc
```

Then the usual
```sh
sudo apt update
sudo apt install klapki
```
will work on amd64, x32, and i386.

See the [repository README](//debian.nabijaczleweli.xyz/README) for more information.

## Uninstallation

Remove the variable corresponding to the host under the klapki GUID (`a8a9ad3a-f831-11ea-946d-674ccd7415cc`).

For example, on Linux, with host "zoot":
```sh
chattr -i /sys/firmware/efi/efivars/zoot-a8a9ad3a-f831-11ea-946d-674ccd7415cc
rm        /sys/firmware/efi/efivars/zoot-a8a9ad3a-f831-11ea-946d-674ccd7415cc
```

This will abandon any previously-managed entries by removing all state, so either run `{delkernel ver}` for all versions you had registered beforehand,
or remove the entries and files later with [`efibootmgr(8)`](//manpages.debian.org/bullseye/efibootmgr/efibootmgr.8.en.html)/EFI shell/the firmware UI.

## Reporting bugs

There's [the tracker](//todo.sr.ht/~nabijaczleweli/klapki), but also see the list below.

## Contributing

Send a patch inline, as an attachment, or a git link and a ref to pull from to
[the list](//lists.sr.ht/~nabijaczleweli/klapki) ([~nabijaczleweli/klapki@lists.sr.ht](mailto:~nabijaczleweli/klapki@lists.sr.ht)) or [me](mailto:nabijaczleweli@nabijaczleweli.xyz)
directly. I'm not picky, just please include the repo name in the subject prefix.

## Discussion

Please use the tracker, the list, or [Twitter](//twitter.com/nabijaczleweli/status/1306144037070569472).

## Special thanks

To all who support further development on Patreon, in particular:

  * ThePhD
  * Embark Studios
  * Jasper Bekkers
