// The MIT License (MIT)

// Copyright (c) 2020 наб <nabijaczleweli@nabijaczleweli.xyz>

// Permission is hereby granted, free of charge, to any person obtaining a copy of
// this software and associated documentation files (the "Software"), to deal in
// the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


#include "state.hpp"
#include "test-util.hpp"
#include <catch2/catch.hpp>
#include <fmt/format.h>
#include <unordered_map>


static std::unordered_map<const char *, klapki::state::stated_config> states = {
    {"just-bootplace", klapki::state::stated_config{0x0a01, {}, {}}},
    {"just-kbase",
     klapki::state::stated_config{0x0b02,
                                  {},
                                  {{0x0102,
                                    {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13},
                                    "5.8.0-1-amd64",
                                    "",
                                    "/boot/",
                                    {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00},
                                    {}}}}},
    {"one-initrd",
     klapki::state::stated_config{
         0x0b02,
         {"test"},
         {{0x0102,
           {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13},
           "5.8.0-1-amd64",
           "debug",
           "/boot/",
           {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00},
           {{"/boot/initrds", {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00}}}}}}},
    {"one-initrd-copy+two-initrds",
     klapki::state::stated_config{
         0x0b02,
         {"test", "2st"},
         {{0x0102,
           {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13},
           "5.8.0-1-amd64",
           "loud",
           "/boot/",
           {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00},
           {{{}, {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00}}}},
          {0x0102,
           {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13},
           "5.8.0-1-amd64",
           "quiet",
           "/boot/",
           {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00},
           {
               {"/boot/initrds", {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00}},
               {"/boot", {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00}},
           }}}}},
    {"exempli-gratia",
     klapki::state::stated_config{
         0x0020,
         {"owo"},
         {{0x000B,
           {0x7C, 0x72, 0x2D, 0xF4, 0x1B, 0x78, 0xEF, 0xC7, 0xC4, 0x07, 0x20, 0xBA, 0x67, 0x54, 0xFC, 0x36, 0x6D, 0x8F, 0xE5, 0x39},
           "5.8.0-1-amd64",
           "",
           "/boot",
           {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00},
           {{{}, {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00}}}},
          {0x000D,
           {0xB0, 0x7C, 0x71, 0x35, 0x33, 0xEC, 0x0F, 0x2E, 0x21, 0x3C, 0xBF, 0xA2, 0x46, 0x1F, 0xD7, 0x25, 0xD5, 0x5D, 0xFE, 0xD4},
           "5.8.0-1-amd64",
           "owo",
           "/boot",
           {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00},
           {{{}, {0x13, 0x12, 0x11, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00}}}}}}},
};


TEST_CASE("klapki::state::stated_config::parse() ENODATA", "[klapki::state::stated_config::parse]") {
	klapki::state::stated_config clean{};
	clean.boot_position = __LINE__;
	auto cclean         = clean;

	klapki::state::stated_config::parse(clean, nullptr, 0);
	REQUIRE(clean == cclean);

	klapki::state::stated_config::parse(clean, nullptr, 1);
	REQUIRE(clean == cclean);
}

TEST_CASE("klapki::state::stated_config::parse() okay", "[klapki::state::stated_config::parse]") {
	for(auto && [name, cfg] : states)
		SECTION(name) {
			const auto indata = klapki::test::read_file(std::string{"test-data/state_parse/"} + name);

			klapki::state::stated_config incfg{};
			klapki::state::stated_config::parse(incfg, indata.data(), indata.size());
			// for(auto && ent : incfg.wanted_entries)
			// 	fmt::print(stderr,
			// 	           "\tbootnum_hint: {}\n"
			// 	           "\tload_option_sha: {}\n"
			// 	           "\tversion: {}\n"
			// 	           "\tkernel_dirname: {}\n"
			// 	           "\tinitrd_dirnames: [{}]\n",
			// 	           ent.bootnum_hint, std::string{(char *)ent.load_option_sha, sizeof(ent.load_option_sha)}, ent.version, ent.kernel_dirname,
			// 	           ent.initrd_dirnames.size());
			// REQUIRE(incfg.boot_position == cfg.boot_position);
			// REQUIRE(incfg.wanted_entries.size() == cfg.wanted_entries.size());
			// for(std::size_t i = 0; i < incfg.wanted_entries.size(); ++i) {
			// 	REQUIRE(incfg.wanted_entries[i].bootnum_hint == cfg.wanted_entries[i].bootnum_hint);
			// 	// REQUIRE(incfg.wanted_entries[i].load_option_sha == cfg.wanted_entries[i].load_option_sha);
			// 	REQUIRE(incfg.wanted_entries[i].version == cfg.wanted_entries[i].version);
			// 	REQUIRE(incfg.wanted_entries[i].kernel_dirname == cfg.wanted_entries[i].kernel_dirname);
			// 	REQUIRE(incfg.wanted_entries[i].initrd_dirnames.size() == cfg.wanted_entries[i].initrd_dirnames.size());
			// 	for(std::size_t n = 0; n < incfg.wanted_entries[i].initrd_dirnames.size(); ++n) {
			// 		fmt::print(stderr, "{}\n", n);
			// 		fmt::print(stderr, "{}\n", incfg.wanted_entries[i].initrd_dirnames[n].value_or("<blegh>"));
			// 		fmt::print(stderr, "{}\n", cfg.wanted_entries[i].initrd_dirnames[n].value_or("<blegh>"));
			// 		REQUIRE(incfg.wanted_entries[i].initrd_dirnames[n] == cfg.wanted_entries[i].initrd_dirnames[n]);
			// 	}
			// }
			// REQUIRE(incfg.wanted_entries == cfg.wanted_entries);
			REQUIRE(incfg == cfg);
		}
}
