// SPDX-License-Identifier: MIT


#define DOCTEST_CONFIG_IMPLEMENT
#include <doctest/doctest.h>

#include "context.hpp"
#include <cassert>
#include <cstdio>
#include <sched.h>
#include <sys/mount.h>
#include <sys/stat.h>


int main(int argc, char ** argv) {
	auto uid = geteuid();
	auto gid = getegid();
	if(uid) {
		assert(!unshare(CLONE_NEWUSER));
#define UNSHARE_FILE(path, ...)        \
	{                                    \
		FILE * f = std::fopen(path, "we"); \
		assert(f);                         \
		std::fprintf(f, __VA_ARGS__);      \
		std::fclose(f);                    \
	}
		UNSHARE_FILE("/proc/self/setgroups", "deny");
		UNSHARE_FILE("/proc/self/uid_map", "0 %d 1", (int)uid);
		UNSHARE_FILE("/proc/self/gid_map", "0 %d 1", (int)gid);
	}

	assert(!unshare(CLONE_NEWNS));
	assert(!mount("none", "/", nullptr, MS_REC | MS_PRIVATE, nullptr));

	assert(!mount("none", "/tmp", "tmpfs", 0, nullptr));
	assert(!mkdir("/tmp/test-data", 0777));

	assert(!mount("test-data", "/tmp/test-data", nullptr, MS_BIND, nullptr));

	assert(!chdir("/tmp"));

	UNSHARE_FILE("cmdline", "root=PARTLABEL=klest\n");
	assert(!mount("cmdline", "/proc/cmdline", nullptr, MS_BIND, nullptr));

	assert(!mount("none", "/boot", "tmpfs", 0, nullptr));
	assert(!mkdir("/boot/efi", 0777));

	return doctest::Context(argc, argv).run();
}


// #include "state.hpp"
// TEST_CASE("dump_stat3") {
// 	std::uint8_t q[] = {...};
// 	klapki::state::stated_config ret;
// 	klapki::state::stated_config::parse(ret, q, sizeof(q));
//
// 	REQUIRE(false);
// }


bool klapki::context::operator==(const our_kernel & lhs, const our_kernel & rhs) {
	return lhs.description == rhs.description && lhs.cmdline == rhs.cmdline && lhs.image_path == rhs.image_path && lhs.initrd_paths == rhs.initrd_paths;
}

bool klapki::context::operator==(const fresh_kernel & lhs, const fresh_kernel & rhs) {
	return lhs.version == rhs.version && lhs.image == rhs.image && lhs.initrds == rhs.initrds;
}
