// SPDX-License-Identifier: 0BSD


#include "sha1.hpp"
#include <sha1.h>


// Alteratively:
// #include <openssl/sha.h>
// ::SHA1(static_cast<const unsigned char *>(data), len, hash);

void klapki::SHA1(const void * data, std::size_t len, sha_t & hash) {
	SHA1_CTX ctx;
	SHA1Init(&ctx);
	SHA1Update(&ctx, static_cast<const std::uint8_t *>(data), len);
	SHA1Final(hash, &ctx);
}
