// SPDX-License-Identifier: 0BSD
// cc .generate.c -o .generate -lz
// rm *.Z
// ./.generate *


#include <assert.h>
#include <fcntl.h>
#include <inttypes.h>
#include <stdio.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <zlib.h>


int main(int argc, char ** argv) {
	while(*++argv) {
		puts(*argv);
		int fd         = open(*argv, O_RDONLY | O_CLOEXEC);
		struct stat sb = {};
		fstat(fd, &sb);
		uint8_t * fc = mmap(NULL, sb.st_size, PROT_READ, MAP_PRIVATE, fd, 0);
		assert(fc != MAP_FAILED);
		close(fd);

		assert(sb.st_size <= 0xFFFF);
		uint16_t encoded_size = htobe16(sb.st_size);

		uint8_t outbuf[0xFFFF * 2];
		uLongf outlen = sizeof(outbuf);
		assert(compress2(outbuf, &outlen, fc, sb.st_size, Z_BEST_COMPRESSION) == Z_OK);

		int padded_len = 2 + sizeof(encoded_size) + outlen;
		printf("	%d -> %d\n", (int)sb.st_size, padded_len);
		if(padded_len < sb.st_size || (fc[0] == 0xFF && fc[1] == 0xFF)) {
			puts("	wins");

			char fn[NAME_MAX + 1];
			stpcpy(stpcpy(fn, *argv), ".Z");
			int outfd = open(fn, O_WRONLY | O_CREAT | O_EXCL | O_CLOEXEC, 0666);
			assert(write(outfd, "\xFF\xFF", 2) == 2);
			assert(write(outfd, &encoded_size, sizeof(encoded_size)) == sizeof(encoded_size));
			assert(write(outfd, outbuf, outlen) == outlen);
			close(outfd);
		}
		munmap(fc, sb.st_size);
	}
}
