// SPDX-License-Identifier: 0BSD


#include "context.hpp"
#include "state.hpp"
#include <doctest/doctest.h>

using namespace std::literals;


#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
TEST_CASE("klapki::context::context::purge_allocations") {
	klapki::state::state state{.order = klapki::state::boot_order_structured{.ours = {0}}, .entries = {{0, {}}}, .statecfg = {.wanted_entries = {{0}}}};
	klapki::context::context ctx{.our_kernels = {{0,
	                                              {.image_path   = {"image dir"s, "image file"s},
	                                               .initrd_paths = {{std::nullopt, "image-derived initrd file"s},  //
	                                                                {"initrd dir"s, "initrd file"s},               //
	                                                                {std::nullopt, "initrd-derived initrd file"s}}}}}};

	ctx.purge_allocations(state, [](auto &&) { return true; });
	REQUIRE(state.entries.empty());
	REQUIRE(std::get<klapki::state::boot_order_structured>(state.order).ours.empty());
	REQUIRE(state.statecfg.wanted_entries.empty());

	REQUIRE(ctx.deleted_files == std::set<std::pair<std::string, std::string>>{{"image dir"s, "image file"s},
	                                                                           {"image dir"s, "image-derived initrd file"},
	                                                                           {"initrd dir"s, "initrd file"},
	                                                                           {"initrd dir"s, "initrd-derived initrd file"}});
}
