// SPDX-License-Identifier: MIT


#pragma once


#include <fmt/format.h>
#include <numeric>
#include <string_view>
extern "C" {
#include <efiboot.h>
}


namespace klapki::context::detail {
	struct bad_cow {
		std::variant<std::string_view, std::string> data;

		constexpr std::string_view get() const noexcept {
			return std::visit([](auto && h) { return std::string_view{h}; }, this->data);
		}

		template <class O>
		constexpr bool operator==(const O & other) const noexcept {
			return this->get() == other;
		}
		constexpr bool operator==(const bad_cow & other) const noexcept { return this->get() == other.get(); }

		constexpr bool operator<(const bad_cow & other) const noexcept { return this->get() < other.get(); }
	};

	struct sha_f {
		const std::uint8_t * sha;
	};

	std::string fmt_devpath(const efidp_data * dp, ssize_t dp_len);
}


template <>
struct fmt::formatter<klapki::context::detail::sha_f> {
	constexpr auto parse(format_parse_context & ctx) { return ctx.begin(); }

	template <typename FormatContext>
	auto format(klapki::context::detail::sha_f s, FormatContext & ctx) {
		return std::accumulate(s.sha, s.sha + sizeof(klapki::sha_t), ctx.out(), [](auto && out, auto b) { return format_to(out, "{:02X}", b); });
	}
};
