// SPDX-License-Identifier: MIT


#pragma once

#include <cstdlib>


namespace klapki {
	namespace {
		/// unique_ptr deleter that uses free(3)
		struct free_deleter {
			template <class T>
			void operator()(T * ptr) const noexcept {
				std::free(ptr);
			}
		};


		/// Stolen from https://en.cppreference.com/w/cpp/utility/variant/visit
		template <class... Ts>
		struct overload : Ts... {
			using Ts::operator()...;
		};
		template <class... Ts>
		overload(Ts...) -> overload<Ts...>;
	}
}
