// SPDX-License-Identifier: MIT


#include "config.hpp"
#include "context.hpp"
#include "state.hpp"
#include "test_eq.hpp"
#include <doctest/doctest.h>

using namespace std::literals;


//  https://todo.sr.ht/~nabijaczleweli/klapki/1
static const klapki::config context_save_sorting_config{
    .host            = "a2b398a10f5f4af99258999e14093599"s,
    .verbose         = false,
    .commit          = true,
    .esp             = "/boot/efi"sv,
    .ops             = {klapki::ops::addvariant{"debug"}},
    .efi_root_raw    = "\\klapki"sv,
    .wisdom_root_raw = "/tmp/rozbian/"sv,
};

static const klapki::state::state context_save_sorting_state_pre{
    klapki::state::boot_order_structured{.foreign = {0x0001, 0x0003, 0x0004}, .ours = {0x0000, 0x0005}},
    {{0x0000, {.attributes = EFI_VARIABLE_NON_VOLATILE | EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_RUNTIME_ACCESS}},  //
     {0x0001, {.attributes = EFI_VARIABLE_NON_VOLATILE | EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_RUNTIME_ACCESS}},  //
     {0x0003, {.attributes = EFI_VARIABLE_NON_VOLATILE | EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_RUNTIME_ACCESS}},  //
     {0x0004, {.attributes = EFI_VARIABLE_NON_VOLATILE | EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_RUNTIME_ACCESS}},  //
     {0x0005, {.attributes = EFI_VARIABLE_NON_VOLATILE | EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_RUNTIME_ACCESS}}},

    {.boot_position  = 0x0000,
     .variants       = {},
     .wanted_entries = {klapki::state::stated_config_entry{
                            .bootnum_hint     = 0x0000,
                            .load_option_sha  = {/*whatever*/},
                            .version          = "6.9.8-amd64",
                            .variant          = "",
                            .kernel_dirname   = "/boot",
                            .kernel_image_sha = {/*whatever*/},
                            .initrd_dirnames  = {std::pair<klapki::state::nonbase_dirname_t, klapki::state::shaa_t>{/*.first  =*/std::nullopt,
                                                                                                                   /*.second =*/{/*whatever*/}}}},
                        klapki::state::stated_config_entry{
                            .bootnum_hint     = 0x0005,
                            .load_option_sha  = {/*whatever*/},
                            .version          = "6.10.3-amd64",
                            .variant          = "",
                            .kernel_dirname   = "/boot",
                            .kernel_image_sha = {/*whatever*/},
                            .initrd_dirnames  = {std::pair<klapki::state::nonbase_dirname_t, klapki::state::shaa_t>{/*.first  =*/std::nullopt,
                                                                                                                   /*.second =*/{/*whatever*/}}}}}}};

static const klapki::context::context context_save_sorting_context{
    .our_kernels = {{0x0000,
                     {"Debian GNU/Linux trixie/sid with Linux 6.9.8-amd64",
                      "(cmdline)",
                      {R"(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.9.8-AMD64\)", R"(VMLINUZ-6.9.8-AMD64)"},
                      {{R"(\klapki\a2b398a10f5f4af99258999e14093599\6.9.8-amd64\)", R"(initrd.img-6.9.8-amd64)"}}}},
                    {0x0005,
                     {"Debian GNU/Linux trixie/sid with Linux 6.10.3-amd64",
                      "(cmdline)",
                      {R"(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.10.3-AMD64\)", R"(VMLINUZ-6.10.3-AMD64)"},
                      {{R"(\klapki\a2b398a10f5f4af99258999e14093599\6.10.3-amd64\)", R"(initrd.img-6.10.3-amd64)"}}}}}};

TEST_CASE("klapki::context::context::save() version sorting") {
	auto state = context_save_sorting_state_pre;
	auto ctx   = context_save_sorting_context;
	REQUIRE(err{ctx.save(context_save_sorting_config, state, HD_Entire)});

	klapki::state::state new_order{klapki::state::boot_order_flat{std::shared_ptr<std::uint16_t[]>{new std::uint16_t[]{0x0005, 0x0000, 0x0001, 0x0003, 0x0004}}, 5}};
	FLAT_BOOT_ORDER_EQ(state, new_order);

	CONTEXT_EQ(ctx, context_save_sorting_context);
}
