// SPDX-License-Identifier: MIT


#define NAME "rozbian"
#include "everything.hpp"

// # efibootmgr -u
// BootCurrent: 0006
// Timeout: 1 seconds
// BootOrder: 0006,0005,0002,0003,0004
// Boot0002* UEFI:CD/DVD Drive	BBS(129,,0x0)
// Boot0003* UEFI:Removable Device	BBS(130,,0x0)
// Boot0004* UEFI:Network Device	BBS(131,,0x0)
// Boot0005* Debian GNU/Linux trixie/sid with Linux 6.4.0-1-amd64
// HD(1,GPT,2823eeb4-962f-cb4d-86ea-c0a4e460bc9c,0x800,0xfa000)/File(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.4.0-1-AMD64\VMLINUZ-6.4.0-1-AMD64)initrd=\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\initrd.img-6.4.0-1-amd64
// root=zfs:AUTO resume=PARTLABEL=rozbian-swap quiet iommu=on
// Boot0006* Debian GNU/Linux trixie/sid with Linux 6.4.0-1-amd64
// HD(1,GPT,2823eeb4-962f-cb4d-86ea-c0a4e460bc9c,0x800,0xfa000)/File(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.4.0-1-AMD64\VMLINUZ-6.4.0-1-AMD64)initrd=\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\initrd.img-6.4.0-1-amd64
// root=zfs:AUTO resume=PARTLABEL=rozbian-swap quiet iommu=on
//
// # for f in Boot000*; do { head -c 4 > /dev/null; cat; } < $f | sha1sum; echo $f; done | paste - -
// 6041dfca108fcdaff4b4247e449c8a9928de412c  -     Boot0002-8be4df61-93ca-11d2-aa0d-00e098032b8c
// 9ee7260155853ae8481fd8ae6f18ebc4391ddad0  -     Boot0003-8be4df61-93ca-11d2-aa0d-00e098032b8c
// 4467e2eb9e18e774708e2c7f1c9ded0233a5541f  -     Boot0004-8be4df61-93ca-11d2-aa0d-00e098032b8c
// 99183b20315eb0e308d26ad9580d8d3187dcdb51  -     Boot0005-8be4df61-93ca-11d2-aa0d-00e098032b8c
// 99183b20315eb0e308d26ad9580d8d3187dcdb51  -     Boot0006-8be4df61-93ca-11d2-aa0d-00e098032b8c
//
// # hd -j 4 a2b398a10f5f4af99258999e14093599-a8a9ad3a-f831-11ea-946d-674ccd7415cc
// 000004 00 00 00 00 06 99 18 3b 20 31 5e b0 e3 08 d2 6a  >.......; 1^....j<
// 000014 d9 58 0d 8d 31 87 dc db 51 36 2e 34 2e 30 2d 31  >.X..1...Q6.4.0-1<
// 000024 2d 61 6d 64 36 34 00 00 2f 62 6f 6f 74 00 0d b6  >-amd64../boot...<
// 000034 a6 5b 68 09 a3 ad e5 00 f3 f5 5c bf 93 17 7b 6b  >.[h.......\...{k<
// 000044 b9 cc 1a 00 9a bb 93 c8 e5 f7 6b f3 f4 23 7c 43  >..........k..#|C<
// 000054 bd c0 24 31 21 c7 6f ec 00                       >..$1!.o..<
// 00005d


namespace {
	const klapki::config config{
	    .host            = "a2b398a10f5f4af99258999e14093599"s,
	    .verbose         = false,
	    .commit          = true,
	    .esp             = "/boot/efi"sv,
	    .ops             = {klapki::ops::addvariant{"debug"}},
	    .efi_root_raw    = "\\klapki"sv,
	    .wisdom_root_raw = "/tmp/" NAME "/"sv,
	};
	const std::string_view config_wisdom_description = "echo Debian GNU/Linux trixie/sid with Linux $*";
	const std::string_view config_wisdom_cmdline     = "echo root=zfs:AUTO resume=PARTLABEL=rozbian-swap iommu=on\n"
	                                                   "[ \"$2\" = debug ] && echo verbose debug || echo quiet";

	const klapki::state::state from_step_2{
	    klapki::state::boot_order_flat{std::shared_ptr<std::uint16_t[]>{new std::uint16_t[]{0x0005, 0x0004, 0x0001, 0x0002, 0x0003}}, 5},
	    {// Boot0002-8be4df61-93ca-11d2-aa0d-00e098032b8c
	     {0x0002, boot_entry_raw({0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x55, 0x00, 0x45, 0x00, 0x46, 0x00, 0x49, 0x00, 0x3a, 0x00,
	                              0x43, 0x00, 0x44, 0x00, 0x2f, 0x00, 0x44, 0x00, 0x56, 0x00, 0x44, 0x00, 0x20, 0x00, 0x44, 0x00, 0x72, 0x00, 0x69, 0x00,
	                              0x76, 0x00, 0x65, 0x00, 0x00, 0x00, 0x05, 0x01, 0x09, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x04, 0x00})},
	     // Boot0003-8be4df61-93ca-11d2-aa0d-00e098032b8c
	     {0x0003, boot_entry_raw({0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x55, 0x00, 0x45, 0x00, 0x46, 0x00, 0x49,
	                              0x00, 0x3a, 0x00, 0x52, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x76, 0x00, 0x61, 0x00, 0x62, 0x00,
	                              0x6c, 0x00, 0x65, 0x00, 0x20, 0x00, 0x44, 0x00, 0x65, 0x00, 0x76, 0x00, 0x69, 0x00, 0x63, 0x00, 0x65,
	                              0x00, 0x00, 0x00, 0x05, 0x01, 0x09, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x04, 0x00})},
	     // Boot0004-8be4df61-93ca-11d2-aa0d-00e098032b8c
	     {0x0004, boot_entry_raw({0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x55, 0x00, 0x45, 0x00, 0x46, 0x00, 0x49, 0x00, 0x3a, 0x00, 0x4e,
	                              0x00, 0x65, 0x00, 0x74, 0x00, 0x77, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x6b, 0x00, 0x20, 0x00, 0x44, 0x00, 0x65, 0x00, 0x76, 0x00,
	                              0x69, 0x00, 0x63, 0x00, 0x65, 0x00, 0x00, 0x00, 0x05, 0x01, 0x09, 0x00, 0x83, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x04, 0x00})},
	     // Boot0005-8be4df61-93ca-11d2-aa0d-00e098032b8c
	     {0x0005,
	      boot_entry_raw(
	          {0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x44, 0x00, 0x65, 0x00, 0x62, 0x00, 0x69, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x20, 0x00,
	           0x47, 0x00, 0x4e, 0x00, 0x55, 0x00, 0x2f, 0x00, 0x4c, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x75, 0x00, 0x78, 0x00, 0x20, 0x00, 0x74, 0x00, 0x72, 0x00,
	           0x69, 0x00, 0x78, 0x00, 0x69, 0x00, 0x65, 0x00, 0x2f, 0x00, 0x73, 0x00, 0x69, 0x00, 0x64, 0x00, 0x20, 0x00, 0x77, 0x00, 0x69, 0x00, 0x74, 0x00,
	           0x68, 0x00, 0x20, 0x00, 0x4c, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x75, 0x00, 0x78, 0x00, 0x20, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00,
	           0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x64, 0x00, 0x36, 0x00, 0x34, 0x00, 0x00, 0x00, 0x04, 0x01, 0x2a, 0x00,
	           0x01, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xee, 0x23, 0x28,
	           0x2f, 0x96, 0x4d, 0xcb, 0x86, 0xea, 0xc0, 0xa4, 0xe4, 0x60, 0xbc, 0x9c, 0x02, 0x02, 0x04, 0x04, 0x9e, 0x00, 0x5c, 0x00, 0x4b, 0x00, 0x4c, 0x00,
	           0x41, 0x00, 0x50, 0x00, 0x4b, 0x00, 0x49, 0x00, 0x5c, 0x00, 0x41, 0x00, 0x32, 0x00, 0x42, 0x00, 0x33, 0x00, 0x39, 0x00, 0x38, 0x00, 0x41, 0x00,
	           0x31, 0x00, 0x30, 0x00, 0x46, 0x00, 0x35, 0x00, 0x46, 0x00, 0x34, 0x00, 0x41, 0x00, 0x46, 0x00, 0x39, 0x00, 0x39, 0x00, 0x32, 0x00, 0x35, 0x00,
	           0x38, 0x00, 0x39, 0x00, 0x39, 0x00, 0x39, 0x00, 0x45, 0x00, 0x31, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x33, 0x00, 0x35, 0x00, 0x39, 0x00,
	           0x39, 0x00, 0x5c, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00, 0x41, 0x00, 0x4d, 0x00,
	           0x44, 0x00, 0x36, 0x00, 0x34, 0x00, 0x5c, 0x00, 0x56, 0x00, 0x4d, 0x00, 0x4c, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x55, 0x00, 0x5a, 0x00, 0x2d, 0x00,
	           0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00, 0x41, 0x00, 0x4d, 0x00, 0x44, 0x00, 0x36, 0x00,
	           0x34, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x04, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x72, 0x00, 0x64, 0x00, 0x3d, 0x00, 0x5c, 0x00,
	           0x6b, 0x00, 0x6c, 0x00, 0x61, 0x00, 0x70, 0x00, 0x6b, 0x00, 0x69, 0x00, 0x5c, 0x00, 0x61, 0x00, 0x32, 0x00, 0x62, 0x00, 0x33, 0x00, 0x39, 0x00,
	           0x38, 0x00, 0x61, 0x00, 0x31, 0x00, 0x30, 0x00, 0x66, 0x00, 0x35, 0x00, 0x66, 0x00, 0x34, 0x00, 0x61, 0x00, 0x66, 0x00, 0x39, 0x00, 0x39, 0x00,
	           0x32, 0x00, 0x35, 0x00, 0x38, 0x00, 0x39, 0x00, 0x39, 0x00, 0x39, 0x00, 0x65, 0x00, 0x31, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x33, 0x00,
	           0x35, 0x00, 0x39, 0x00, 0x39, 0x00, 0x5c, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00,
	           0x61, 0x00, 0x6d, 0x00, 0x64, 0x00, 0x36, 0x00, 0x34, 0x00, 0x5c, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x72, 0x00, 0x64, 0x00,
	           0x2e, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x67, 0x00, 0x2d, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00,
	           0x2d, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x64, 0x00, 0x36, 0x00, 0x34, 0x00, 0x20, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x3d, 0x00,
	           0x7a, 0x00, 0x66, 0x00, 0x73, 0x00, 0x3a, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x4f, 0x00, 0x20, 0x00, 0x72, 0x00, 0x65, 0x00, 0x73, 0x00,
	           0x75, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x3d, 0x00, 0x50, 0x00, 0x41, 0x00, 0x52, 0x00, 0x54, 0x00, 0x4c, 0x00, 0x41, 0x00, 0x42, 0x00, 0x45, 0x00,
	           0x4c, 0x00, 0x3d, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x7a, 0x00, 0x62, 0x00, 0x69, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x2d, 0x00, 0x73, 0x00, 0x77, 0x00,
	           0x61, 0x00, 0x70, 0x00, 0x20, 0x00, 0x71, 0x00, 0x75, 0x00, 0x69, 0x00, 0x65, 0x00, 0x74, 0x00, 0x20, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6d, 0x00,
	           0x6d, 0x00, 0x75, 0x00, 0x3d, 0x00, 0x6f, 0x00, 0x6e, 0x00})},
	     // Boot0006-8be4df61-93ca-11d2-aa0d-00e098032b8c
	     {0x0006,
	      boot_entry_raw(
	          {0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x44, 0x00, 0x65, 0x00, 0x62, 0x00, 0x69, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x20, 0x00,
	           0x47, 0x00, 0x4e, 0x00, 0x55, 0x00, 0x2f, 0x00, 0x4c, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x75, 0x00, 0x78, 0x00, 0x20, 0x00, 0x74, 0x00, 0x72, 0x00,
	           0x69, 0x00, 0x78, 0x00, 0x69, 0x00, 0x65, 0x00, 0x2f, 0x00, 0x73, 0x00, 0x69, 0x00, 0x64, 0x00, 0x20, 0x00, 0x77, 0x00, 0x69, 0x00, 0x74, 0x00,
	           0x68, 0x00, 0x20, 0x00, 0x4c, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x75, 0x00, 0x78, 0x00, 0x20, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00,
	           0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x64, 0x00, 0x36, 0x00, 0x34, 0x00, 0x00, 0x00, 0x04, 0x01, 0x2a, 0x00,
	           0x01, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xee, 0x23, 0x28,
	           0x2f, 0x96, 0x4d, 0xcb, 0x86, 0xea, 0xc0, 0xa4, 0xe4, 0x60, 0xbc, 0x9c, 0x02, 0x02, 0x04, 0x04, 0x9e, 0x00, 0x5c, 0x00, 0x4b, 0x00, 0x4c, 0x00,
	           0x41, 0x00, 0x50, 0x00, 0x4b, 0x00, 0x49, 0x00, 0x5c, 0x00, 0x41, 0x00, 0x32, 0x00, 0x42, 0x00, 0x33, 0x00, 0x39, 0x00, 0x38, 0x00, 0x41, 0x00,
	           0x31, 0x00, 0x30, 0x00, 0x46, 0x00, 0x35, 0x00, 0x46, 0x00, 0x34, 0x00, 0x41, 0x00, 0x46, 0x00, 0x39, 0x00, 0x39, 0x00, 0x32, 0x00, 0x35, 0x00,
	           0x38, 0x00, 0x39, 0x00, 0x39, 0x00, 0x39, 0x00, 0x45, 0x00, 0x31, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x33, 0x00, 0x35, 0x00, 0x39, 0x00,
	           0x39, 0x00, 0x5c, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00, 0x41, 0x00, 0x4d, 0x00,
	           0x44, 0x00, 0x36, 0x00, 0x34, 0x00, 0x5c, 0x00, 0x56, 0x00, 0x4d, 0x00, 0x4c, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x55, 0x00, 0x5a, 0x00, 0x2d, 0x00,
	           0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00, 0x41, 0x00, 0x4d, 0x00, 0x44, 0x00, 0x36, 0x00,
	           0x34, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x04, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x72, 0x00, 0x64, 0x00, 0x3d, 0x00, 0x5c, 0x00,
	           0x6b, 0x00, 0x6c, 0x00, 0x61, 0x00, 0x70, 0x00, 0x6b, 0x00, 0x69, 0x00, 0x5c, 0x00, 0x61, 0x00, 0x32, 0x00, 0x62, 0x00, 0x33, 0x00, 0x39, 0x00,
	           0x38, 0x00, 0x61, 0x00, 0x31, 0x00, 0x30, 0x00, 0x66, 0x00, 0x35, 0x00, 0x66, 0x00, 0x34, 0x00, 0x61, 0x00, 0x66, 0x00, 0x39, 0x00, 0x39, 0x00,
	           0x32, 0x00, 0x35, 0x00, 0x38, 0x00, 0x39, 0x00, 0x39, 0x00, 0x39, 0x00, 0x65, 0x00, 0x31, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x33, 0x00,
	           0x35, 0x00, 0x39, 0x00, 0x39, 0x00, 0x5c, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2d, 0x00,
	           0x61, 0x00, 0x6d, 0x00, 0x64, 0x00, 0x36, 0x00, 0x34, 0x00, 0x5c, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x72, 0x00, 0x64, 0x00,
	           0x2e, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x67, 0x00, 0x2d, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x31, 0x00,
	           0x2d, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x64, 0x00, 0x36, 0x00, 0x34, 0x00, 0x20, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x3d, 0x00,
	           0x7a, 0x00, 0x66, 0x00, 0x73, 0x00, 0x3a, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x4f, 0x00, 0x20, 0x00, 0x72, 0x00, 0x65, 0x00, 0x73, 0x00,
	           0x75, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x3d, 0x00, 0x50, 0x00, 0x41, 0x00, 0x52, 0x00, 0x54, 0x00, 0x4c, 0x00, 0x41, 0x00, 0x42, 0x00, 0x45, 0x00,
	           0x4c, 0x00, 0x3d, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x7a, 0x00, 0x62, 0x00, 0x69, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x2d, 0x00, 0x73, 0x00, 0x77, 0x00,
	           0x61, 0x00, 0x70, 0x00, 0x20, 0x00, 0x71, 0x00, 0x75, 0x00, 0x69, 0x00, 0x65, 0x00, 0x74, 0x00, 0x20, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6d, 0x00,
	           0x6d, 0x00, 0x75, 0x00, 0x3d, 0x00, 0x6f, 0x00, 0x6e, 0x00})}},

	    {.boot_position  = 0x0000,
	     .variants       = {},
	     .wanted_entries = {klapki::state::stated_config_entry{
	         .bootnum_hint     = 0x0006,
	         .load_option_sha  = {0x99, 0x18, 0x3b, 0x20, 0x31, 0x5e, 0xb0, 0xe3, 0x8, 0xd2, 0x6a, 0xd9, 0x58, 0xd, 0x8d, 0x31, 0x87, 0xdc, 0xdb, 0x51},
	         .version          = "6.4.0-1-amd64",
	         .variant          = "",
	         .kernel_dirname   = "/boot",
	         .kernel_image_sha = {0xd, 0xb6, 0xa6, 0x5b, 0x68, 0x9, 0xa3, 0xad, 0xe5, 0x0, 0xf3, 0xf5, 0x5c, 0xbf, 0x93, 0x17, 0x7b, 0x6b, 0xb9, 0xcc},
	         .initrd_dirnames  = {std::pair<klapki::state::nonbase_dirname_t, klapki::state::shaa_t>{
               /*.first  =*/std::nullopt,
               /*.second =*/{0x9a, 0xbb, 0x93, 0xc8, 0xe5, 0xf7, 0x6b, 0xf3, 0xf4, 0x23, 0x7c, 0x43, 0xbd, 0xc0, 0x24, 0x31, 0x21, 0xc7, 0x6f, 0xec}}}}}}


	};

	const klapki::state::state from_step_3 = [] {
		auto ret  = from_step_2;
		ret.order = klapki::state::boot_order_structured{.foreign = {0x0005, 0x0004, 0x0001, 0x0002, 0x0003}};
		std::memcpy(ret.entries[0x0002].load_option_sha, "\x60\x41\xdf\xca\x10\x8f\xcd\xaf\xf4\xb4\x24\x7e\x44\x9c\x8a\x99\x28\xde\x41\x2c", sizeof(klapki::sha_t));
		std::memcpy(ret.entries[0x0003].load_option_sha, "\x9e\xe7\x26\x01\x55\x85\x3a\xe8\x48\x1f\xd8\xae\x6f\x18\xeb\xc4\x39\x1d\xda\xd0", sizeof(klapki::sha_t));
		std::memcpy(ret.entries[0x0004].load_option_sha, "\x44\x67\xe2\xeb\x9e\x18\xe7\x74\x70\x8e\x2c\x7f\x1c\x9d\xed\x02\x33\xa5\x54\x1f", sizeof(klapki::sha_t));
		std::memcpy(ret.entries[0x0005].load_option_sha, "\x99\x18\x3b\x20\x31\x5e\xb0\xe3\x08\xd2\x6a\xd9\x58\x0d\x8d\x31\x87\xdc\xdb\x51", sizeof(klapki::sha_t));
		std::memcpy(ret.entries[0x0006].load_option_sha, "\x99\x18\x3b\x20\x31\x5e\xb0\xe3\x08\xd2\x6a\xd9\x58\x0d\x8d\x31\x87\xdc\xdb\x51", sizeof(klapki::sha_t));
		return ret;
	}();

	const klapki::context::context from_step_4{
	    .our_kernels = {
	        /*{0x0005,
	         {"Debian GNU/Linux trixie/sid with Linux 6.4.0-1-amd64",
	          R"(initrd=\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\initrd.img-6.4.0-1-amd64 root=zfs:AUTO resume=PARTLABEL=rozbian-swap quiet
	         iommu=on)", {R"(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.4.0-1-AMD64\)", R"(VMLINUZ-6.4.0-1-AMD64)"},
	          {{R"(\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\)", R"(initrd.img-6.4.0-1-amd64)"}}}},*/
	        {0x0006,
	         {"Debian GNU/Linux trixie/sid with Linux 6.4.0-1-amd64",
	          R"(initrd=\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\initrd.img-6.4.0-1-amd64 root=zfs:AUTO resume=PARTLABEL=rozbian-swap quiet iommu=on)",
	          {R"(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.4.0-1-AMD64\)", R"(VMLINUZ-6.4.0-1-AMD64)"},
	          {{R"(\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\)", R"(initrd.img-6.4.0-1-amd64)"}}}}}};

	const klapki::state::state from_step_5_state = [] {
		auto ret = from_step_3;
		ret.statecfg.variants.emplace_back("debug"sv);
		return ret;
	}();
	const klapki::context::context from_step_5_context = from_step_4;

	const klapki::state::state from_step_6_state = [] {
		auto ret = from_step_5_state;

		std::get<klapki::state::boot_order_structured>(ret.order).ours.emplace_back(0x0000);

		ret.entries[0x0000] = {.attributes = EFI_VARIABLE_NON_VOLATILE | EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_RUNTIME_ACCESS};

		auto && went      = ret.statecfg.wanted_entries.emplace_back(ret.statecfg.wanted_entries[0]);
		went.bootnum_hint = 0x0000;
		std::memset(went.load_option_sha, 0, sizeof(klapki::sha_t));
		went.variant = "debug";

		return ret;
	}();
	const klapki::context::context from_step_6_context = [] {
		auto ret = from_step_5_context;

		ret.our_kernels[0x0000]             = ret.our_kernels[0x0006];
		ret.our_kernels[0x0000].description = "";
		ret.our_kernels[0x0000].image_path.first =
		    (((((""s += config.efi_root()) += "\\"sv) += config.host) += "\\"sv) += from_step_6_state.statecfg.wanted_entries.back().version) += "\\"sv;
		ret.our_kernels[0x0000].cmdline = "";

		return ret;
	}();

	const klapki::state::state from_step_7_state       = from_step_6_state;
	const klapki::context::context from_step_7_context = from_step_6_context;

	const klapki::context::context from_step_8 = [] {
		auto ret = from_step_7_context;

		ret.our_kernels[0x0006].description = "Debian GNU/Linux trixie/sid with Linux 6.4.0-1-amd64"s;
		ret.our_kernels[0x0006].cmdline     = "root=zfs:AUTO resume=PARTLABEL=rozbian-swap iommu=on quiet"s;

		ret.our_kernels[0x0000].description = "Debian GNU/Linux trixie/sid with Linux 6.4.0-1-amd64 debug"s;
		ret.our_kernels[0x0000].cmdline     = "root=zfs:AUTO resume=PARTLABEL=rozbian-swap iommu=on verbose debug"s;

		return ret;
	}();

	const klapki::state::state from_step_9_state = [] {
		auto ret  = from_step_7_state;
		ret.order = klapki::state::boot_order_flat{std::shared_ptr<std::uint16_t[]>{new std::uint16_t[]{0x0000, 0x0005, 0x0004, 0x0001, 0x0002, 0x0003}}, 6};


		auto img = R"(\KLAPKI\A2B398A10F5F4AF99258999E14093599\6.4.0-1-AMD64\VMLINUZ-6.4.0-1-AMD64)"sv;
		std::vector<std::uint8_t> devpath_file_node(efidp_make_file(nullptr, 0, const_cast<char *>(img.data())));
		assert(efidp_make_file(devpath_file_node.data(), devpath_file_node.size(), const_cast<char *>(img.data())) >= 0);

		efidp_data * devpath;
		assert(efidp_append_node(HD_Entire, reinterpret_cast<const efidp_data *>(devpath_file_node.data()), &devpath) >= 0);
		const auto devpath_len = efidp_size(devpath);


		{
			auto cmdline_u8 = R"(initrd=\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\initrd.img-6.4.0-1-amd64 )"s +=
			    from_step_8.our_kernels.at(0x0006).cmdline;
			std::vector<std::uint16_t> cmdline;
			std::copy(std::begin(cmdline_u8), std::end(cmdline_u8), std::back_inserter(cmdline));

			ret.entries[0x0006].load_option_len =
			    efi_loadopt_create(nullptr, 0,                                                                                                    //
			                       ret.entries[0x0006].attributes,                                                                                //
			                       devpath, devpath_len,                                                                                          //
			                       reinterpret_cast<unsigned char *>(const_cast<char *>(from_step_8.our_kernels.at(0x0006).description.data())),  //
			                       reinterpret_cast<std::uint8_t *>(cmdline.data()), cmdline.size() * 2);

			ret.entries[0x0006].load_option = std::make_shared_for_overwrite<std::uint8_t[]>(ret.entries[0x0006].load_option_len);
			assert(efi_loadopt_create(ret.entries[0x0006].load_option.get(), ret.entries[0x0006].load_option_len,                                    //
			                          ret.entries[0x0006].attributes,                                                                                //
			                          devpath, devpath_len,                                                                                          //
			                          reinterpret_cast<unsigned char *>(const_cast<char *>(from_step_8.our_kernels.at(0x0006).description.data())),  //
			                          reinterpret_cast<std::uint8_t *>(cmdline.data()), cmdline.size() * 2) >= 0);

			std::memcpy(ret.entries[0x0006].load_option_sha, "\xed\x75\x9a\x0a\xa6\x75\x85\x43\x69\x0b\x08\x5c\xac\x40\x88\x92\x7f\x7f\x48\xdf",
			            sizeof(klapki::sha_t));
			std::memcpy(ret.statecfg.wanted_entries[0].load_option_sha, "\xed\x75\x9a\x0a\xa6\x75\x85\x43\x69\x0b\x08\x5c\xac\x40\x88\x92\x7f\x7f\x48\xdf",
			            sizeof(klapki::sha_t));
		}

		{
			auto cmdline_u8 = R"(initrd=\klapki\a2b398a10f5f4af99258999e14093599\6.4.0-1-amd64\initrd.img-6.4.0-1-amd64 )"s +=
			    from_step_8.our_kernels.at(0x0000).cmdline;
			std::vector<std::uint16_t> cmdline;
			std::copy(std::begin(cmdline_u8), std::end(cmdline_u8), std::back_inserter(cmdline));

			ret.entries[0x0000].load_option_len =
			    efi_loadopt_create(nullptr, 0,                                                                                                    //
			                       ret.entries[0x0000].attributes,                                                                                //
			                       devpath, devpath_len,                                                                                          //
			                       reinterpret_cast<unsigned char *>(const_cast<char *>(from_step_8.our_kernels.at(0x0000).description.data())),  //
			                       reinterpret_cast<std::uint8_t *>(cmdline.data()), cmdline.size() * 2);

			ret.entries[0x0000].load_option = std::make_shared_for_overwrite<std::uint8_t[]>(ret.entries[0x0000].load_option_len);
			assert(efi_loadopt_create(ret.entries[0x0000].load_option.get(), ret.entries[0x0000].load_option_len,                                    //
			                          ret.entries[0x0000].attributes,                                                                                //
			                          devpath, devpath_len,                                                                                          //
			                          reinterpret_cast<unsigned char *>(const_cast<char *>(from_step_8.our_kernels.at(0x0000).description.data())),  //
			                          reinterpret_cast<std::uint8_t *>(cmdline.data()), cmdline.size() * 2) >= 0);

			std::memcpy(ret.entries[0x0000].load_option_sha, "\x62\xfe\xf1\x96\xd2\x65\x8a\xc6\xcb\xe4\x7d\x38\x16\xa0\xb9\xc2\xc3\xff\xd8\x5c",
			            sizeof(klapki::sha_t));
			std::memcpy(ret.statecfg.wanted_entries[1].load_option_sha, "\x62\xfe\xf1\x96\xd2\x65\x8a\xc6\xcb\xe4\x7d\x38\x16\xa0\xb9\xc2\xc3\xff\xd8\x5c",
			            sizeof(klapki::sha_t));
		}


		std::free(devpath);
		return ret;
	}();
	const klapki::context::context from_step_9_context = from_step_8;

	/// https://www.di-mgt.com.au/sha_testvectors.html
	std::vector<std::tuple<const char *, bool, std::string_view, std::string_view>> step_10_files{
	    {"/boot/VmLiNuZ-6.4.0-1-aMd64", false, "6.4.0-1-amd64"sv, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"sv},  //
	    {"/boot/iNiTrD.iMg-6.4.0-1-AmD64", false, "6.4.0-1-amd64"sv, "abc"sv}};
	const klapki::state::state from_step_10 = [] {
		auto ret = from_step_9_state;
		std::memcpy(ret.statecfg.wanted_entries[0].kernel_image_sha, "\x84\x98\x3e\x44\x1c\x3b\xd2\x6e\xba\xae\x4a\xa1\xf9\x51\x29\xe5\xe5\x46\x70\xf1",
		            sizeof(klapki::sha_t));
		std::memcpy(ret.statecfg.wanted_entries[1].kernel_image_sha, "\x84\x98\x3e\x44\x1c\x3b\xd2\x6e\xba\xae\x4a\xa1\xf9\x51\x29\xe5\xe5\x46\x70\xf1",
		            sizeof(klapki::sha_t));
		std::memcpy(ret.statecfg.wanted_entries[0].initrd_dirnames[0].second.data(),
		            "\xa9\x99\x3e\x36\x47\x06\x81\x6a\xba\x3e\x25\x71\x78\x50\xc2\x6c\x9c\xd0\xd8\x9d", sizeof(klapki::sha_t));
		std::memcpy(ret.statecfg.wanted_entries[1].initrd_dirnames[0].second.data(),
		            "\xa9\x99\x3e\x36\x47\x06\x81\x6a\xba\x3e\x25\x71\x78\x50\xc2\x6c\x9c\xd0\xd8\x9d", sizeof(klapki::sha_t));
		return ret;
	}();
}
