# 🐀 [ratrun](//twitter.com/nabijaczleweli/status/1586903771581501445) [![builds.sr.ht build status](//builds.sr.ht/~nabijaczleweli/ratrun.svg)](//builds.sr.ht/~nabijaczleweli/ratrun)[![Licence](//img.shields.io/badge/licence-0BSD-blue.svg?style=flat)](LICENCE)
atrun(8) for the rat race.

## [Manual](https://srhtcdn.githack.com/~nabijaczleweli/ratrun/blob/man/man0/index.0.html) ([PDF](//srhtcdn.githack.com/~nabijaczleweli/ratrun/blob/man/ratrun.pdf))
(mandoc really does a number on the HTML output, I recommend the PDF)

## Synopsis
Three components of equal size.

`ratrun` (pp. 4-5) reads calendar-style events in a trivial format (or a subset of [iCal](//www.rfc-editor.org/rfc/rfc5545)) from `~/.ratrun`,
sends reminders when reminders expire, and when they all do, moves the events to `~/.ratrun/old`.

`rat` (pp. 1-2) can be used as a conversational scheduler.

The iCalendar subset is expected to be compatible with commercial calendaring systems (Outlook, Teams, GCalendar, Evolution, &c.), but see errata in ratrun.ics(5) (p. 3).

## Building
Needs GNU make, AWK, mandoc (linting and HTML manuals only, `MANDOC=:` to disable), and shellcheck (for shell wrappers, `SHELLCHECK=:` to disable), and gettext (only if you want localisation).

Set `RATRUN_RUNNERDIR=` (default of `/usr/libexec/`, used only by manuals) if you'll put `ratrun` in the PATH.

`VOREUTILS_VERSION` and `VOREUTILS_DATE` are derived from the git HEAD by default.

## Installation
Put:
  * `${CMDDIR?-out/cmd}/ratrun` somewhere compatible with `RATRUN_RUNNERDIR`,
  * `${CMDDIR?-out/cmd}/rat` in the $PATH somewhere,
  * `ratrun` in `/etc/default`,
  * `${LOCDIR?-out/locale}` in `/usr/share` (or $TEXTDOMAINDIR),
  * `${MANDIR?-out/man}` in `/usr/share` (or wherever your $MANPATH reaches).

Adjust `/etc/default/ratrun` to suit your mail setup, and both it and your cron config to run `ratrun -a` to suit your (users') tastes.

Needs:
  * MAWK or stronger (probably hard-POSIX AWK would suffice, but I haven't tried) – for iCal support
  * `/usr/share/zoneinfo` (tzdata) – for iCal support
  * setpriv(1) (util-linux) – for `-a`, it'd be easy to replace with an equivalent
  * flock(1) (util-linux) – for event locking to prevent funny moments; you could shim it out if you're brave
  * mail(1) (4.4BSD-compatible, default config is mailutils, see preset for s-nail; there's security (well, "users using ratrun as atrun") considerations about (`~`) escapes)
  * date(1) with useful `-d`, mv(1) with `-bS` and truncate(1) with `-s`
  * POSIX-compatible shell (bash in POSIX mode (default when run with argv[0]=sh) qualifies, god save you if you run it out of POSIX mode though)

Recommends:
  * gettext(1) (gettext-base) – shimmed out, but that removes localisation
  * getent(1) (libc-bin) – polyfilled to interrogate `/etc/{passwd,group}` instead

<!-- ### From Debian repository
The following line in `/etc/apt/sources.list` or equivalent:
```
deb [signed-by=/etc/apt/keyrings/nabijaczleweli.asc] https://debian.nabijaczleweli.xyz sid main
```

With my PGP key (the two URLs are interchangeable):
```sh
sudo wget -O/etc/apt/keyrings/nabijaczleweli.asc https://debian.nabijaczleweli.xyz/nabijaczleweli.gpg.key
sudo wget -O/etc/apt/keyrings/nabijaczleweli.asc https://nabijaczleweli.xyz/pgp.txt
```
(you may need to create /etc/apt/keyrings on apt <2.4.0 (<=bullseye) manually).

Then the usual
```sh
sudo apt update
sudo apt install ratrun
```
will.

See the repository README or the source package for more information. -->

## Contributing/opining
Post to
[the tracker](//todo.sr.ht/~nabijaczleweli/ratrun) ([~nabijaczleweli/ratrun@todo.sr.ht](mailto:~nabijaczleweli/ratrun@todo.sr.ht), preferable for bugs),
[the list](//lists.sr.ht/~nabijaczleweli/ratrun)
([~nabijaczleweli/ratrun@lists.sr.ht](mailto:~nabijaczleweli/ratrun@lists.sr.ht), preferable for opinions and patches), or
[me](mailto:nabijaczleweli@nabijaczleweli.xyz) directly (now with [Platform](//twitter.com/nabijaczleweli) integration!).

Not picky about patches — inline, attachment, and a git link and ref to pull are fine — just please include the repo name in the subject prefix.

## Licence
All contents of this repository are subject to the [0-clause BSD licence](LICENCE).

## Special thanks
To Cicada for his Francophone insights.

To all who support further development on Patreon, in particular:
  * Embark Studios
