#!/bin/sh -fC
# SPDX-License-Identifier: 0BSD
# shellcheck disable=SC2059,SC2030,SC2031,SC2086,SC2188

command -v gettext > /dev/null || alias gettext='printf %s'
niusage() {
	printf "$(TEXTDOMAIN=ratrun gettext 'non-interactive usage: %s [%%]when event [reminders] [body…]\n                       %s event [%%]when [reminders] [body…]\n')" "$0" "$0" >&2
	exit 1
}

# shellcheck source=ratrun
{ [ -r "${CONFDIR:=/etc/default}/ratrun" ] && . "$CONFDIR/ratrun"; } ||
	{ < "$CONFDIR/ratrun"; alias unsuff='printf "%s "'; alias resuff='printf "%s "'; }

cd ~/.ratrun 2>/dev/null || { mkdir -p ~/.ratrun && cd ~/.ratrun; } || exit
read -r TZ 2>/dev/null < .tz && export TZ


dfl=''

[ "$1" = '--' ] && shift
when="$dfl"; [ $# -ge 1 ] && { when="$1"; shift; }
evnt="$dfl"; [ $# -ge 1 ] && { evnt="$1"; shift; }
if   [ "$when" != "$dfl" ] && [ "$evnt" =  "$dfl" ] && ! date -d "${when#%}" +_ > /dev/null 2>&1; then
	printf "$(TEXTDOMAIN=ratrun gettext '%s: %s unacceptable as date, using as event name\n')" "$0" "$when" >&2
	tmp="$when"; when="$evnt"; evnt="$tmp"
elif [ "$when" != "$dfl" ] && [ "$evnt" != "$dfl" ] && ! date -d "${when#%}" +_ > /dev/null 2>&1 && date -d "${evnt#%}" +_ > /dev/null 2>&1; then
	printf "$(TEXTDOMAIN=ratrun gettext '%s: %s unacceptable as date, but %s is; exchanging\n')" "$0" "$when" "$evnt" >&2
	tmp="$when"; when="$evnt"; evnt="$tmp"
fi

dok=0
while :; do
	if [ "$when" = "$dfl" ]; then
		[ -t 0 ] || niusage
		TEXTDOMAIN=ratrun gettext 'Event date/time (start with % to canonicalise): ' >&2
		read -r when || exit
		# date(1) format here!
		date -d "${when#%}" +"${date_fmt:="$(TEXTDOMAIN=ratrun gettext 'Happens on %c')"}" || { when="$dfl"; continue; }
		dok=1
	else
		if ! date -d "${when#%}" +_ > /dev/null 2>&1; then
			printf "$(TEXTDOMAIN=ratrun gettext '%s: %s unacceptable as date\n')" "$0" "$when" >&2
			[ -t 0 ] && { when="$dfl"; continue; } || exit 1
		fi
	fi
	break
done
[ $dok -eq 1 ] || date -d "${when#%}" +"${date_fmt:="$(TEXTDOMAIN=ratrun gettext 'Happens on %c')"}"


while [ "$evnt" = "$dfl" ] || [ -z "$evnt" ]; do
	[ -t 0 ] || niusage
	TEXTDOMAIN=ratrun gettext 'Event: ' >&2
	read -r evnt || exit
done


cleanup() {
	printf "$(TEXTDOMAIN=ratrun gettext '%s: killed by signal, unscheduling %s\n')" "$0" "$nevnt" >&2
	rm -f -- "$nevnt"
	exit 127
}
trap cleanup HUP INT QUIT TERM
nevnt="$(
	trap 'rm -f -- "$nevnt"' HUP INT QUIT TERM
	[ "${evnt%/*}" != "$evnt" ] && evnt="$(printf '%s\n' "$evnt" | tr / _)"
	# empty file = no line = ignored
	nevnt="$evnt"                                             && > "$nevnt" && printf '%s\n' "$nevnt" && exit
	nevnt="$evnt-${when#%}"                                   && > "$nevnt" && printf '%s\n' "$nevnt" && exit
	nevnt="$evnt-$(date -d "${when#%}" +'%Y-%m-%dT%H:%M%:z')" && > "$nevnt" && printf '%s\n' "$nevnt" && exit  # -Iminutes
)" 2>/dev/null
[ -z "$nevnt" ] && {
	# User-entered date/time here; likely to be a time
	printf "$(TEXTDOMAIN=ratrun gettext "%s: too many identical events, couldn't allocate file for \"%s\" at %s\n")" "$0" "$evnt" "${when#%}" >&2
	exit 1
}
# "renamed to remove collisions"
[ "$nevnt" != "$evnt" ] && printf "$(TEXTDOMAIN=ratrun gettext '%s: "%s" decollided to "%s"\n')" "$0" "$evnt" "$nevnt" >&2
evnt="$nevnt"

exec >> "$evnt"
flock 1

[ "${when#%}" != "$when" ] && when="$(date -d "${when#%}" +'%Y-%m-%dT%H:%M%:z')"  # -Iminutes
printf '%s\n' "$when"
whensecs="$(date -d "$when" +'%s')"

rmnd="$dfl"; [ $# -ge 1 ] && { [ "${1#[0-9]}" != "$1" ] && { rmnd="$1"; shift; } || rmnd=; }

demind() {
	ret=0
	for r; do
		secs="$(unsuff "$r")"; secs="${secs% }"
		if [ "${secs%[^0-9]*}" != "$secs" ]; then
			onreflow
			secs="$(date -d "$r" +'%s')" || { onerr; continue; }
			secs=$(( whensecs - secs ))
			# user input, then unsuffed reminder ("20h"/"118m")
			[ "$secs" -ge 0 ] || { printf "$(TEXTDOMAIN=ratrun gettext '%s: %s is %safter the event!\n')" "$0" "$r" "$(resuff "${secs#-}")" >&2; onerr; continue; }
		fi
		resuff "$secs"
	done
	exit $ret
}

read -r RATRUN_REMINDERS 2>/dev/null < .reminders

# In context of reminders; used as the default value below instead of a list
[ -z "$RATRUN_REMINDERS" ] && RATRUN_REMINDERS="$(TEXTDOMAIN=ratrun gettext 'none!')"


reencoded=
[ "$rmnd" = "$dfl" ] && {
	if [ -e '.nevermind' ]; then
		rmnd=
	elif [ -t 0 ]; then
		while [ "$rmnd" = "$dfl" ]; do
			printf "${remp:="$(TEXTDOMAIN=ratrun gettext 'Reminders (clock times OK; empty = default (%s)): ')"}" "$RATRUN_REMINDERS" >&2
			read -r rmnd || {
				exec <&-  # Might want to turn this into < /dev/null if we ever prompt for anything more than a body
				rmnd=
				# User ^Ded in the reminders prompt, this is to inform them that an empty mail body will be used for the event notifications; "Using empty body"/"No body"
				printf "$(TEXTDOMAIN=ratrun gettext '\nBody empty.\n')" >&2
				break
			}

			rmnd="$(onreflow() { ret=66; }; onerr() { exit 1; }; demind $rmnd)"
			case $? in
				0)	reencoded=y ;;
				# In context of the reminders, e.g. if you said 18:45 this may say 15m
				66)	reencoded=y; printf "$(TEXTDOMAIN=ratrun gettext 'Reencoded as %s\n')" "$rmnd" >&2 ;;
				*)	rmnd="$dfl" ;;
			esac
			rmnd="${rmnd% }"
		done
	else
		rmnd=
	fi
}

[ -n "$rmnd" ] && [ -z "$reencoded" ] && {
	nr="$(onreflow() { :; }; onerr() { printf '%s ' "$r"; ret=1; }; demind $rmnd)" || {
    # In context of the reminders, e.g. if you said 18: (which is invalid); actual times listed by date(1)
		printf "$(TEXTDOMAIN=ratrun gettext '%s: using the above verbatim\n')" "$0" >&2
	}
	nr="${nr% }"
	# In context of the reminders, e.g. if you said 18:45
	[ "$nr" != "$rmnd" ] && printf "$(TEXTDOMAIN=ratrun gettext '%s: reminders normalised to %s\n')" "$0" "$nr" >&2
	rmnd="$nr"
}

printf '%s\n' "$rmnd"


if [ $# -ge 1 ]; then
	printf '%s\n' "$*"
elif [ -t 0 ]; then
	printf "$(TEXTDOMAIN=ratrun gettext 'Enter body; %s to finish\n')" "$(stty -a | sed -n 's/;/\n/g;/^[[:space:]]*eof[[:space:]]*=[[:space:]]*/ {s///;P;q};D')" >&2
	cat
else
	: No body
fi
