#!/bin/sh
# SPDX-License-Identifier: MIT


#include "../mount.h"
WITH_PROMPTABLE_TTY{< /dev/console > /dev/console 2>&1}
#include "../zfs-lib.sh.h"


# Only run on systemd systems, mimicking zfs-dracut's zfs-load-key.sh; TODO: "see mount-zfs.sh for non-systemd systems", confer README
[ -d /run/systemd ] || return 0


. "/lib/dracut-lib.sh"
decode_root_args || return 0


# There is a race between the zpool import and the pre-mount hooks, so we wait for a pool to be imported
while ! systemctl is-active --quiet zfs-import.target; do
    systemctl is-failed --quiet zfs-import-cache.service zfs-import-scan.service && return 1
    sleep 0.1s
done

BOOTFS="$root"
if [ "$BOOTFS" = "zfs:AUTO" ]; then
    BOOTFS="$(zpool get -Ho value bootfs | grep -m1 -vFx -)"
fi

[ "$(zpool get -Ho value feature@encryption "${BOOTFS%%/*}")" = 'active' ] || return 0


getarg 0 quiet && quiet=y


tzpfms_load() {
    set -- "$(zfs get -Ho value encryptionroot "$1")"
    [ "$1" = "-" ] && return 0

    # Match this sexion to i-t/zfs-patch.sh
    if command -v zfs-tpm2-load-key > /dev/null && [ -n "$(zfs-tpm-list -Hub TPM2 "$1")" ]; then
        with_promptable_tty zfs-tpm2-load-key "$1"
        return
    fi

    if command -v zfs-tpm1x-load-key > /dev/null && [ -n "$(zfs-tpm-list -Hub TPM1.X "$1")" ]; then
        POTENTIALLY_START_TCSD{ss -ltO, > /dev/console 2>&1}
        with_promptable_tty zfs-tpm1x-load-key "$1"; err="$?"
        POTENTIALLY_KILL_TCSD{}
        return "$err"
    fi
}


tzpfms_load "$BOOTFS"
for_relevant_root_children "$BOOTFS" tzpfms_load
